/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.jslt.it;

import com.schibsted.spt.data.jslt.Expression;
import com.schibsted.spt.data.jslt.Function;
import com.schibsted.spt.data.jslt.JsltException;
import com.schibsted.spt.data.jslt.Parser;
import com.schibsted.spt.data.jslt.filters.JsltJsonFilter;
import com.schibsted.spt.data.jslt.filters.JsonFilter;
import com.schibsted.spt.data.jslt.impl.FunctionWrapper;
import jakarta.inject.Named;
import java.lang.reflect.Method;
import java.util.Collections;
import org.apache.camel.component.jslt.JsltComponent;

public class JsltConfiguration {
    @Named
    JsltComponent jsltWithFilter() {
        Expression filterExpression = Parser.compileString((String)". != null and . != {}");
        JsltJsonFilter filter = new JsltJsonFilter(filterExpression);
        JsltComponent component = new JsltComponent();
        component.setObjectFilter((JsonFilter)filter);
        return component;
    }

    @Named
    JsltComponent jsltWithFunction() throws ClassNotFoundException {
        JsltComponent component = new JsltComponent();
        component.setFunctions(Collections.singleton(JsltConfiguration.wrapStaticMethod("power", "org.apache.camel.quarkus.component.jslt.it.MathFunctionStub", "pow")));
        component.setAllowTemplateFromHeader(true);
        return component;
    }

    public static Function wrapStaticMethod(String functionName, String className, String methodName) throws LinkageError, ExceptionInInitializerError, ClassNotFoundException {
        Class<?> klass = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
        Method[] methods = klass.getMethods();
        Method method = null;
        for (int ix = 0; ix < methods.length; ++ix) {
            if (!methods[ix].getName().equals(methodName)) continue;
            if (method == null) {
                method = methods[ix];
                continue;
            }
            throw new JsltException("More than one method named '" + methodName + "'");
        }
        if (method == null) {
            throw new JsltException("No such method: '" + methodName + "'");
        }
        return new FunctionWrapper(functionName, method);
    }

    public static Ping createInfiniteRecursionObject() {
        Pong pong;
        Ping ping = new Ping();
        ping.pong = pong = new Pong();
        pong.ping = ping;
        return ping;
    }

    private static class Ping {
        private Pong pong;

        private Ping() {
        }
    }

    private static class Pong {
        private Ping ping;

        private Pong() {
        }
    }
}

