/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.jslt.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.camel.util.FileUtil;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

@QuarkusTest
class JsltTest {
    JsltTest() {
    }

    @Test
    public void transformInputStreamShouldSucceed() throws IOException {
        String expected = IOUtils.resourceToString((String)"/demoPlayground/output.json", (Charset)StandardCharsets.UTF_8);
        String input = IOUtils.resourceToString((String)"/demoPlayground/input.json", (Charset)StandardCharsets.UTF_8);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().body(input).get("/jslt/transformInputStream", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)expected), new Matcher[0]);
    }

    @Test
    public void transformInvalidBodyShouldIssueValidationErrorMessage() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/jslt/transformInvalidBody", new Object[0])).then()).statusCode(200)).body(Matchers.startsWith((String)"Allowed body types are String or InputStream."), new Matcher[0]);
    }

    @Test
    public void transformStringShouldSucceed() throws IOException {
        String expected = IOUtils.resourceToString((String)"/demoPlayground/output.json", (Charset)StandardCharsets.UTF_8);
        String input = IOUtils.resourceToString((String)"/demoPlayground/input.json", (Charset)StandardCharsets.UTF_8);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().body(input).get("/jslt/transformString", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)expected), new Matcher[0]);
    }

    @Test
    public void transformFromHeaderWithPrettyPrintShouldSucceed() throws IOException {
        String expected = IOUtils.resourceToString((String)"/demoPlayground/outputPrettyPrint.json", (Charset)StandardCharsets.UTF_8);
        String input = IOUtils.resourceToString((String)"/demoPlayground/input.json", (Charset)StandardCharsets.UTF_8);
        if (FileUtil.isWindows()) {
            expected = expected.replace("\n", System.lineSeparator());
        }
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().body(input).get("/jslt/transformFromHeaderWithPrettyPrint", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)expected), new Matcher[0]);
    }

    @Test
    public void transformInputStreamWithFilterShouldSucceed() throws IOException {
        String expected = IOUtils.resourceToString((String)"/objectFilter/output.json", (Charset)StandardCharsets.UTF_8);
        String input = IOUtils.resourceToString((String)"/objectFilter/input.json", (Charset)StandardCharsets.UTF_8);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().body(input).get("/jslt/transformInputStreamWithFilter", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)expected), new Matcher[0]);
    }

    @Test
    public void transformInputStreamWithVariablesShouldSucceed() throws IOException {
        String expected = IOUtils.resourceToString((String)"/withVariables/output.json", (Charset)StandardCharsets.UTF_8);
        String input = IOUtils.resourceToString((String)"/withVariables/input.json", (Charset)StandardCharsets.UTF_8);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().body(input).get("/jslt/transformInputStreamWithVariables", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)expected), new Matcher[0]);
    }

    @Test
    public void transformInputStreamWithVariablesAndPropertiesShouldSucceed() throws IOException {
        String expected = IOUtils.resourceToString((String)"/withVariables/outputWithProperties.json", (Charset)StandardCharsets.UTF_8);
        String input = IOUtils.resourceToString((String)"/withVariables/input.json", (Charset)StandardCharsets.UTF_8);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().body(input).get("/jslt/transformInputStreamWithVariablesAndProperties", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)expected), new Matcher[0]);
    }

    @Test
    public void transformWithFunctionShouldSucceed() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/jslt/transformWithFunction", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"1024.0"), new Matcher[0]);
    }
}

