/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.dsl.jsh;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.stream.Collectors;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.Route;
import org.apache.camel.quarkus.main.CamelMain;

@Path(value="/jsh-dsl")
@ApplicationScoped
public class JshDslResource {
    @Inject
    CamelMain main;
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/main/jshRoutesBuilderLoader")
    @GET
    @Produces(value={"text/plain"})
    public String jshRoutesBuilder() {
        ExtendedCamelContext camelContext = this.main.getCamelContext().getCamelContextExtension();
        return ((Class)camelContext.getBootstrapFactoryFinder("META-INF/services/org/apache/camel/routes-loader/").findClass("jsh").get()).getName();
    }

    @Path(value="/main/routeBuilders")
    @GET
    @Produces(value={"text/plain"})
    public String routeBuilders() {
        return this.main.configure().getRoutesBuilders().stream().map(rb -> rb.getClass().getSimpleName()).sorted().collect(Collectors.joining(","));
    }

    @Path(value="/main/routes")
    @GET
    @Produces(value={"text/plain"})
    public String routes() {
        return this.main.getCamelContext().getRoutes().stream().map(Route::getId).sorted().collect(Collectors.joining(","));
    }

    @POST
    @Path(value="/hello")
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String hello(String message) {
        return (String)this.producerTemplate.requestBody("direct:jshHello", (Object)message, String.class);
    }
}

