/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.jsch.it;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.FluentProducerTemplate;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@Path(value="/jsch")
public class JschResource {
    @ConfigProperty(name="jsch.username")
    String username;
    @ConfigProperty(name="jsch.password")
    String password;
    @ConfigProperty(name="jsch.host")
    String host;
    @ConfigProperty(name="jsch.port")
    int port;
    @Inject
    FluentProducerTemplate fluentProducerTemplate;
    @Inject
    ConsumerTemplate consumerTemplate;

    @Path(value="/file/copy")
    @POST
    public Response copyFile(@QueryParam(value="message") String message, String path) throws Exception {
        java.nio.file.Path filePath = Paths.get(path, new String[0]);
        String knownHosts = this.setupKnownHosts(filePath.getParent());
        this.fluentProducerTemplate.toF("scp://%s:%s?username=%s&password=%s&knownHostsFile=%s&chmod=755&privateKeyFile=classpath:camel-key.pgp", new Object[]{this.host, this.port, this.username, this.password, knownHosts}).withHeader("CamelFileName", (Object)filePath.getFileName().toString()).withBody((Object)message).send();
        return Response.ok().build();
    }

    @Path(value="/file/get")
    @Produces(value={"text/plain"})
    @GET
    public String getFile(@QueryParam(value="path") String path) throws Exception {
        java.nio.file.Path filePath = Paths.get(path, new String[0]);
        String knownHosts = this.setupKnownHosts(filePath.getParent());
        String fileName = filePath.getFileName().toString();
        return (String)this.consumerTemplate.receiveBodyNoWait("sftp://admin@{{jsch.host}}:{{jsch.port}}?username={{jsch.username}}&password={{jsch.password}}&knownHostsFile=" + knownHosts + "&localWorkDirectory=target&fileName=" + fileName, String.class);
    }

    private String setupKnownHosts(java.nio.file.Path baseDir) throws Exception {
        java.nio.file.Path knownHosts = baseDir.resolve("known_hosts");
        if (!Files.exists(knownHosts, new LinkOption[0])) {
            Files.createFile(knownHosts, new FileAttribute[0]);
            JSch jsch = new JSch();
            jsch.setKnownHosts(knownHosts.toAbsolutePath().toString());
            Session s = jsch.getSession(this.username, this.host, this.port);
            s.setConfig("StrictHostKeyChecking", "ask");
            s.setConfig("HashKnownHosts", "no");
            s.setUserInfo(new UserInfo(){

                public String getPassphrase() {
                    return null;
                }

                public String getPassword() {
                    return JschResource.this.password;
                }

                public boolean promptPassword(String message) {
                    return true;
                }

                public boolean promptPassphrase(String message) {
                    return false;
                }

                public boolean promptYesNo(String message) {
                    return true;
                }

                public void showMessage(String message) {
                }
            });
            s.connect();
            s.disconnect();
        }
        return knownHosts.toString();
    }
}

