/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.js;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.Route;
import org.apache.camel.component.direct.DirectEndpoint;
import org.apache.camel.quarkus.main.CamelMain;

@Path(value="/js-dsl")
@ApplicationScoped
public class JavaScriptDslResource {
    @Inject
    CamelMain main;
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/main/jsRoutesBuilderLoader")
    @GET
    @Produces(value={"text/plain"})
    public String jsRoutesBuilder() {
        ExtendedCamelContext camelContext = this.main.getCamelContext().getCamelContextExtension();
        return ((Class)camelContext.getBootstrapFactoryFinder("META-INF/services/org/apache/camel/routes-loader/").findClass("js").get()).getName();
    }

    @Path(value="/main/routeBuilders")
    @GET
    @Produces(value={"text/plain"})
    public String routeBuilders() {
        return this.main.configure().getRoutesBuilders().stream().map(rb -> rb.getClass().getSimpleName()).sorted().collect(Collectors.joining(","));
    }

    @Path(value="/main/routes")
    @GET
    @Produces(value={"text/plain"})
    public String routes() {
        return this.main.getCamelContext().getRoutes().stream().map(Route::getId).sorted().collect(Collectors.joining(","));
    }

    @GET
    @Path(value="/main/successful/routes")
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public int successfulRoutes() {
        Set<String> excluded = Set.of("my-js-route", "routes-with-rest-dsl-hello", "routes-with-rest-configuration-goodbye");
        int successful = 0;
        for (Route route : this.main.getCamelContext().getRoutes()) {
            String name = route.getRouteId();
            if (!(route.getEndpoint() instanceof DirectEndpoint) || excluded.contains(name) || this.producerTemplate.requestBody(route.getEndpoint(), (Object)"", Boolean.class) != Boolean.TRUE) continue;
            ++successful;
        }
        return successful;
    }

    @POST
    @Path(value="/hello")
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String hello(String message) {
        return (String)this.producerTemplate.requestBody("direct:jsHello", (Object)message, String.class);
    }
}

