/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.jq.it;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.quarkus.component.jq.it.Book;

@Path(value="/jq")
@ApplicationScoped
public class JqResource {
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    CamelContext context;
    @Inject
    ObjectMapper mapper;

    @Path(value="/expression")
    @GET
    public void expression() throws Exception {
        MockEndpoint endpoint = (MockEndpoint)this.context.getEndpoint("mock:expression", MockEndpoint.class);
        endpoint.expectedBodiesReceived(new Object[]{new TextNode("bar")});
        ObjectNode node = this.mapper.createObjectNode().put("foo", "bar").put("baz", "bar");
        this.producerTemplate.sendBody("direct:expression", (Object)node.put("value", "valid"));
        endpoint.assertIsSatisfied(5000L);
    }

    @Path(value="/expression/header")
    @GET
    public void expressionHeader() throws Exception {
        MockEndpoint endpoint = (MockEndpoint)this.context.getEndpoint("mock:expressionHeader", MockEndpoint.class);
        TextNode expected = new TextNode("bar");
        endpoint.expectedBodiesReceived(new Object[]{expected});
        ObjectNode node = this.mapper.createObjectNode().put("foo", "bar");
        this.producerTemplate.sendBodyAndHeader("direct:expressionHeader", null, "Content", (Object)node);
        endpoint.assertIsSatisfied(5000L);
    }

    @Path(value="/expression/header/function")
    @GET
    public void expressionHeaderFunction() throws Exception {
        MockEndpoint endpoint = (MockEndpoint)this.context.getEndpoint("mock:expressionHeaderFunction", MockEndpoint.class);
        ObjectNode expected = this.mapper.createObjectNode().put("foo", "MyValue");
        endpoint.expectedBodiesReceived(new Object[]{expected});
        ObjectNode node = this.mapper.createObjectNode().put("foo", "bar");
        this.producerTemplate.sendBodyAndHeader("direct:expressionHeaderFunction", (Object)node, "MyHeader", (Object)"MyValue");
        endpoint.assertIsSatisfied(5000L);
    }

    @Path(value="/expression/header/string")
    @GET
    public void expressionHeaderString() throws Exception {
        MockEndpoint endpoint = (MockEndpoint)this.context.getEndpoint("mock:expressionHeaderString", MockEndpoint.class);
        endpoint.expectedBodiesReceived(new Object[]{"bar"});
        ObjectNode node = this.mapper.createObjectNode().put("foo", "bar");
        this.producerTemplate.sendBodyAndHeader("direct:expressionHeaderString", null, "Content", (Object)node);
        endpoint.assertIsSatisfied(5000L);
    }

    @Path(value="/expression/pojo")
    @GET
    public void expressionPojo() throws Exception {
        MockEndpoint endpoint = (MockEndpoint)this.context.getEndpoint("mock:expressionPojo", MockEndpoint.class);
        endpoint.expectedBodiesReceived(new Object[]{new Book("foo", "bar")});
        ObjectNode node = this.mapper.createObjectNode();
        node.with("book").put("author", "foo").put("title", "bar");
        this.producerTemplate.sendBody("direct:expressionPojo", (Object)node);
        endpoint.assertIsSatisfied(5000L);
    }

    @Path(value="/expression/property")
    @GET
    public void expressionProperty() throws Exception {
        MockEndpoint endpoint = (MockEndpoint)this.context.getEndpoint("mock:expressionProperty", MockEndpoint.class);
        endpoint.expectedMessageCount(1);
        final ObjectNode node = this.mapper.createObjectNode().put("foo", "bar");
        this.producerTemplate.send("direct:expressionProperty", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.setProperty("Content", (Object)node);
            }
        });
        endpoint.assertIsSatisfied(5000L);
    }

    @Path(value="/expression/property/function")
    @GET
    public void expressionPropertyFunction() throws Exception {
        ObjectNode node = this.mapper.createObjectNode().put("foo", "MyPropertyValue");
        MockEndpoint endpoint = (MockEndpoint)this.context.getEndpoint("mock:expressionPropertyFunction", MockEndpoint.class);
        endpoint.expectedBodiesReceived(new Object[]{node});
        this.producerTemplate.send("direct:expressionPropertyFunction", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.setProperty("MyProperty", (Object)"MyPropertyValue");
                exchange.getMessage().setBody((Object)JqResource.this.mapper.createObjectNode().put("foo", "bar"));
            }
        });
        endpoint.assertIsSatisfied(5000L);
    }

    @Path(value="/filter")
    @GET
    public void filter() throws Exception {
        MockEndpoint endpoint = (MockEndpoint)this.context.getEndpoint("mock:filter", MockEndpoint.class);
        ObjectNode expected = this.mapper.createObjectNode().put("value", "valid");
        endpoint.expectedBodiesReceived(new Object[]{expected});
        this.producerTemplate.sendBody("direct:filter", (Object)this.mapper.createObjectNode().put("value", "valid"));
        this.producerTemplate.sendBody("direct:filter", (Object)this.mapper.createObjectNode().put("value", "invalid"));
        endpoint.assertIsSatisfied(5000L);
    }
}

