/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.jpa.it.model;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import org.apache.camel.Exchange;
import org.apache.camel.component.jpa.Consumed;
import org.apache.camel.component.jpa.PreConsumed;

@Entity
@NamedQueries(value={@NamedQuery(name="findByName", query="SELECT f FROM Fruit f WHERE f.name = :fruitName"), @NamedQuery(name="unprocessed", query="SELECT f FROM Fruit f WHERE f.processed = false")})
public class Fruit {
    @Id
    @GeneratedValue
    private Integer id;
    @Column(length=50, unique=true)
    private String name;
    private Boolean processed = false;

    public Fruit() {
    }

    public Fruit(String name) {
        this.name = name;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getProcessed() {
        return this.processed;
    }

    public void setProcessed(Boolean processed) {
        this.processed = processed;
    }

    @PreConsumed
    public void preConsumed(Exchange exchange) {
        exchange.getMessage().setHeader("preConsumed", (Object)true);
    }

    @Consumed
    public void consumed(Exchange exchange) {
        if (this.processed.booleanValue()) {
            throw new AssertionError((Object)"The entity has already been processed!");
        }
        this.setProcessed(true);
    }
}

