/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.jpa.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.persistence.EntityManagerFactory;
import java.util.Collections;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.jpa.TransactionStrategy;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.TransactedDefinition;
import org.apache.camel.processor.idempotent.jpa.JpaMessageIdRepository;
import org.apache.camel.quarkus.component.jpa.it.model.Fruit;
import org.apache.camel.spi.IdempotentRepository;

@ApplicationScoped
public class JpaRoute
extends RouteBuilder {
    @Inject
    EntityManagerFactory entityManagerFactory;
    @Inject
    TransactionStrategy transactionStrategy;

    public void configure() throws Exception {
        String jpaEndpoint = "jpa:" + Fruit.class.getName();
        this.bindToRegistry("parameters", Collections.singletonMap("fruitName", "${body}"));
        this.from("direct:findAll").to(jpaEndpoint + "?query=select f from " + Fruit.class.getName() + " f");
        this.from("direct:findById").to(jpaEndpoint + "?findEntity=true");
        this.from("direct:namedQuery").to(jpaEndpoint + "?namedQuery=findByName&parameters=#parameters");
        this.from("direct:nativeQuery").to(jpaEndpoint + "?resultClass=org.apache.camel.quarkus.component.jpa.it.model.Fruit&nativeQuery=SELECT * FROM fruit WHERE id = :id");
        this.from("direct:store").to(jpaEndpoint);
        this.from("direct:remove").to(jpaEndpoint + "?remove=true");
        ((TransactedDefinition)this.from("direct:transaction").transacted().to("direct:store")).process(x -> {
            if (((Boolean)x.getIn().getHeader("rollback", (Object)false, Boolean.class)).booleanValue()) {
                throw new RuntimeException("forced exception");
            }
        });
        ((RouteDefinition)((RouteDefinition)this.from(jpaEndpoint + "?namedQuery=unprocessed").log("Consume fruit: ${body}")).process(x -> {
            if (!((Boolean)x.getIn().getHeader("preConsumed", Boolean.class)).booleanValue()) {
                throw new AssertionError((Object)"preConsumed method has not been executed");
            }
        })).to("mock:processed");
        ((ExpressionNode)this.from("direct:idempotent").idempotentConsumer((Expression)this.header("messageId"), (IdempotentRepository)new JpaMessageIdRepository(this.entityManagerFactory, this.transactionStrategy, "idempotentProcessor")).log("Consumes messageId: ${header.messageId}")).to("mock:idempotent");
        this.from("direct:idempotentLog").enrich("jpa:MessageProcessed?consumeDelete=false&query=select f from MessageProcessed f");
    }
}

