/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.jpa.it;

import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.quarkus.component.jpa.it.model.Fruit;

@Path(value="/jpa")
public class JpaResource {
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    CamelContext context;

    @Path(value="/fruit")
    @GET
    @Produces(value={"application/json"})
    public List<Fruit> getFruits() {
        return (List)this.producerTemplate.requestBody("direct:findAll", null, List.class);
    }

    @Path(value="/fruit")
    @POST
    @Consumes(value={"application/json"})
    public Response createFruit(Fruit fruit) throws URISyntaxException {
        this.producerTemplate.sendBody("direct:store", (Object)fruit);
        return Response.created((URI)new URI("https://camel.apache.org/")).build();
    }

    @Path(value="/fruit/{id}")
    @DELETE
    public Response deleteFruit(@PathParam(value="id") int id) {
        Fruit fruit = new Fruit();
        fruit.setId(id);
        this.producerTemplate.sendBody("direct:remove", (Object)fruit);
        return Response.ok().build();
    }

    @Path(value="/fruit/{id}")
    @GET
    @Produces(value={"application/json"})
    public Fruit getFruit(@PathParam(value="id") int id) {
        return (Fruit)this.producerTemplate.requestBody("direct:findById", (Object)id, Fruit.class);
    }

    @Path(value="/fruit/named/{name}")
    @GET
    @Produces(value={"application/json"})
    public List<Fruit> getFruitByQuery(@PathParam(value="name") String name) {
        return (List)this.producerTemplate.requestBody("direct:namedQuery", (Object)name, List.class);
    }

    @Path(value="/fruit/native/{id}")
    @GET
    @Produces(value={"application/json"})
    public List<Fruit> getFruitByNativeQuery(@PathParam(value="id") int id) {
        Map<String, Integer> params = Collections.singletonMap("id", id);
        return (List)this.producerTemplate.requestBodyAndHeader("direct:nativeQuery", null, "CamelJpaParameters", params, List.class);
    }

    @Path(value="/direct/{name}")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response triggerDirectEndpoint(@PathParam(value="name") String name, @HeaderParam(value="rollback") Boolean rollback, @HeaderParam(value="messageId") String messageId, Fruit fruit) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("rollback", rollback);
        headers.put("messageId", messageId);
        Object response = this.producerTemplate.requestBodyAndHeaders("direct:" + name, (Object)fruit, headers);
        return Response.ok((Object)response).build();
    }

    @Path(value="/mock/{name}")
    @GET
    @Produces(value={"application/json"})
    public List getMockContent(@PathParam(value="name") String name) {
        MockEndpoint mock = (MockEndpoint)this.context.getEndpoint("mock:" + name, MockEndpoint.class);
        return mock.getReceivedExchanges().stream().map(Exchange::getMessage).map(m -> (String)m.getBody(String.class)).collect(Collectors.toList());
    }

    @Path(value="/mock/{name}")
    @DELETE
    @Produces(value={"application/json"})
    public Response resetMock(@PathParam(value="name") String name) {
        MockEndpoint mock = (MockEndpoint)this.context.getEndpoint("mock:" + name, MockEndpoint.class);
        mock.reset();
        return Response.ok().build();
    }
}

