/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.jpa.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import jakarta.json.bind.JsonbBuilder;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.apache.camel.quarkus.component.jpa.it.model.Fruit;
import org.awaitility.Awaitility;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

@QuarkusTest
class JpaTest {
    static final String[] FRUITS = new String[]{"Orange", "Lemon", "Plum"};

    JpaTest() {
    }

    @BeforeAll
    public static void storeFruits() {
        int port;
        Config config = ConfigProvider.getConfig();
        RestAssured.port = port = ((Integer)config.getValue("quarkus.http.test-port", Integer.TYPE)).intValue();
        for (String fruit : FRUITS) {
            ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(JsonbBuilder.create().toJson((Object)new Fruit(fruit))).post("/jpa/fruit", new Object[0])).then()).statusCode(201);
        }
    }

    @Test
    public void testProducerQuery() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/jpa/fruit", (Object[])new Object[0]).then()).statusCode(200)).body("name", Matchers.containsInAnyOrder((Object[])FRUITS), new Object[0]);
    }

    @Test
    public void testProducerNamedQuery() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)("/jpa/fruit/named/" + FRUITS[0]), (Object[])new Object[0]).then()).statusCode(200)).body("name", Matchers.contains((Object[])new String[]{FRUITS[0]}), new Object[0]);
    }

    @Test
    public void testProducerNativeQuery() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/jpa/fruit/native/2", (Object[])new Object[0]).then()).statusCode(200)).body("name", Matchers.contains((Object[])new String[]{FRUITS[1]}), new Object[0]);
    }

    @Test
    public void testConsumer() {
        IntStream.range(1, 3).parallel().forEach(id -> Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> this.findFruit(id).getProcessed()));
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/jpa/mock/processed", (Object[])new Object[0]).then()).statusCode(200)).body("size()", Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(3)), new Object[0]);
    }

    @Test
    public void testTransaction() {
        Fruit rejected = new Fruit("Potato");
        int acceptedId = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(JsonbBuilder.create().toJson((Object)new Fruit("Grapes"))).post("/jpa/direct/transaction", new Object[0])).then()).statusCode(200)).body("id", Matchers.notNullValue(), new Object[0])).body("name", Matchers.is((Object)"Grapes"), new Object[0])).extract().jsonPath().getInt("id");
        try {
            ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(JsonbBuilder.create().toJson((Object)rejected)).header("rollback", (Object)true, new Object[0]).post("/jpa/direct/transaction", new Object[0])).then()).statusCode(500);
            ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/jpa/fruit/named/Grapes", (Object[])new Object[0]).then()).statusCode(200)).body("name", Matchers.contains((Object[])new String[]{"Grapes"}), new Object[0]);
            ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)("/jpa/fruit/named/" + rejected.getName()), (Object[])new Object[0]).then()).statusCode(200)).body("$.size()", Matchers.is((Object)0), new Object[0]);
        }
        finally {
            ((ValidatableResponse)RestAssured.delete((String)("/jpa/fruit/" + acceptedId), (Object[])new Object[0]).then()).statusCode(200);
        }
    }

    @Test
    public void testJpaMessageIdRepository() {
        IntStream.of(1, 2, 1, 3, 2).forEach(id -> ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(JsonbBuilder.create().toJson((Object)new Fruit(Integer.toString(id)))).header("messageId", (Object)id, new Object[0]).post("/jpa/direct/idempotent", new Object[0])).then()).statusCode(200));
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).post("/jpa/direct/idempotentLog", new Object[0])).then()).statusCode(200)).body("$.size()", Matchers.is((Object)3), new Object[0])).body("messageId", Matchers.containsInAnyOrder((Object[])new String[]{"1", "2", "3"}), new Object[0])).body("processorName", Matchers.hasItems((Object[])new String[]{"idempotentProcessor"}), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/jpa/mock/idempotent", (Object[])new Object[0]).then()).statusCode(200)).body("size()", Matchers.is((Object)3), new Object[0]);
    }

    public Fruit findFruit(int id) {
        return (Fruit)JsonbBuilder.create().fromJson(((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)("/jpa/fruit/" + id), (Object[])new Object[0]).then()).statusCode(200)).extract().body().asString(), Fruit.class);
    }
}

