/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.jolt.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

@QuarkusTest
class JoltTest {
    JoltTest() {
    }

    @Test
    public void defaultrShouldSucceed() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("myValue").put("/jolt/defaultr", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"myString-null-[1, 2]-3.1-3-true+myValue"), new Matcher[0]);
    }

    @Test
    public void removrShouldSucceed() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("myOtherValue").put("/jolt/removr", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"2-Kept+myOtherValue"), new Matcher[0]);
    }

    @Test
    public void sampleShouldSucceed() throws IOException {
        String requestBody = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/sample-input.json"), (Charset)StandardCharsets.UTF_8);
        String expectedResponseBody = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/sample-output.json"), (Charset)StandardCharsets.UTF_8);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(requestBody).contentType(ContentType.JSON).put("/jolt/sample", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)expectedResponseBody), new Matcher[0]);
    }

    @Test
    public void functionShouldSucceed() throws IOException {
        String requestBody = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/function-input.json"), (Charset)StandardCharsets.UTF_8);
        String expectedResponseBody = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/function-output.json"), (Charset)StandardCharsets.UTF_8);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(requestBody).contentType(ContentType.JSON).put("/jolt/function", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)expectedResponseBody), new Matcher[0]);
    }
}

