/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.jolt.it;

import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.camel.ProducerTemplate;
import org.jboss.logging.Logger;

@Path(value="/jolt")
@ApplicationScoped
public class JoltResource {
    private static final Logger LOG = Logger.getLogger(JoltResource.class);
    @Inject
    ProducerTemplate template;

    @Path(value="/defaultr")
    @PUT
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String defaultr(String value) {
        LOG.infof("Calling defaultr with %s", (Object)value);
        HashMap<String, String> inbody = new HashMap<String, String>();
        inbody.put("key", value);
        Map outBody = (Map)this.template.requestBody("jolt:defaultr.json?transformDsl=Defaultr", inbody, Map.class);
        Map outObject = (Map)outBody.get("object");
        return String.format("%s-%s-%s-%s-%s-%s+%s", outBody.get("string"), outBody.get("null"), outBody.get("array"), outBody.get("floating"), outBody.get("integer"), outObject.get("boolean"), outBody.get("key"));
    }

    @Path(value="/removr")
    @PUT
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String removr(String value) {
        LOG.infof("Calling removr with %s", (Object)value);
        HashMap<String, String> inBody = new HashMap<String, String>();
        inBody.put("keepMe", "Kept");
        inBody.put("key", value);
        inBody.put("removeMe", "This should be gone");
        Map outBody = (Map)this.template.requestBody("jolt:removr.json?transformDsl=Removr", inBody, Map.class);
        return String.format("%s-%s+%s", outBody.size(), outBody.get("keepMe"), outBody.get("key"));
    }

    @Path(value="/sample")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String sample(String inputJson) {
        LOG.infof("Calling sample with %s", (Object)inputJson);
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("contextB", "bb");
        String joltEndpointUri = "jolt:sample-spec.json?inputType=JsonString&outputType=JsonString&allowTemplateFromHeader=true";
        return (String)this.template.requestBodyAndHeader(joltEndpointUri, (Object)inputJson, "CamelJoltContext", context, String.class);
    }

    @Path(value="/function")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String function(String inputJson) {
        LOG.infof("Calling function with %s", (Object)inputJson);
        String joltEndpointUri = "jolt:function-spec.json?inputType=JsonString&outputType=JsonString";
        return (String)this.template.requestBody(joltEndpointUri, (Object)inputJson, String.class);
    }
}

