/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.jira.it;

import com.atlassian.jira.rest.client.api.domain.Comment;
import com.atlassian.jira.rest.client.api.domain.Issue;
import jakarta.inject.Inject;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.ProducerTemplate;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@Path(value="/jira")
public class JiraResource {
    @Inject
    ConsumerTemplate consumerTemplate;
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    CamelContext context;
    @ConfigProperty(name="jira.issues.project-key")
    String projectKey;

    @Path(value="/issue")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    public Response createIssue(@QueryParam(value="type") String type, @QueryParam(value="summary") String summary, String description) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("ProjectKey", this.projectKey);
        headers.put("IssueTypeName", type);
        headers.put("IssueSummary", summary);
        Issue issue = (Issue)this.producerTemplate.requestBodyAndHeaders("jira:addIssue", (Object)description, headers, Issue.class);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)this.issueToJson(issue)).status(201).build();
    }

    @Path(value="/issue/{key}")
    @GET
    @Produces(value={"application/json"})
    public Response readIssueByKey(@PathParam(value="key") String key) {
        try {
            Issue issue = (Issue)this.producerTemplate.requestBodyAndHeader("jira:fetchIssue", null, "IssueKey", (Object)key, Issue.class);
            return Response.ok((Object)this.issueToJson(issue)).build();
        }
        catch (Exception e) {
            return Response.status((int)404).build();
        }
    }

    @Path(value="/issue")
    @GET
    @Produces(value={"application/json"})
    public Response readIssue(@QueryParam(value="source") String source) {
        Issue issue;
        String uriSuffix = "jiraIssues";
        if (source.equals("update")) {
            uriSuffix = "jiraUpdates";
        }
        if ((issue = (Issue)this.consumerTemplate.receiveBody("seda:" + uriSuffix, 10000L, Issue.class)) == null) {
            return Response.noContent().build();
        }
        return Response.ok((Object)this.issueToJson(issue)).build();
    }

    @Path(value="/issue/{key}")
    @PATCH
    public Response updateIssue(@PathParam(value="key") String key, String issueSummary) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("IssueKey", key);
        headers.put("IssueSummary", issueSummary);
        this.producerTemplate.requestBodyAndHeaders("jira:updateIssue", null, headers);
        return Response.ok().build();
    }

    @Path(value="/issue/{key}")
    @DELETE
    public Response deleteIssue(@PathParam(value="key") String key) {
        this.producerTemplate.requestBodyAndHeader("jira:deleteIssue", null, "IssueKey", (Object)key);
        return Response.noContent().build();
    }

    @Path(value="/issue/{key}/comment")
    @POST
    @Consumes(value={"text/plain"})
    public Response createIssueComment(@PathParam(value="key") String key, String comment) throws Exception {
        this.producerTemplate.requestBodyAndHeader("jira:addComment", (Object)comment, "IssueKey", (Object)key);
        return Response.created((URI)new URI("https://camel.apache.org/")).build();
    }

    @Path(value="/issue/comment")
    @GET
    @Produces(value={"text/plain"})
    public Response getIssueComment() {
        Comment comment = (Comment)this.consumerTemplate.receiveBody("seda:jiraComments", 10000L, Comment.class);
        if (comment == null) {
            return Response.noContent().build();
        }
        return Response.ok((Object)comment.getBody()).build();
    }

    @Path(value="/issue/{key}/attach")
    @POST
    @Consumes(value={"text/plain"})
    public Response createIssueAttachment(@PathParam(value="key") String key, String content) throws Exception {
        java.nio.file.Path tempFile = Files.createTempFile("cq-jira", ".txt", new FileAttribute[0]);
        Files.write(tempFile, content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        this.producerTemplate.requestBodyAndHeader("jira:attach", (Object)tempFile.toFile(), "IssueKey", (Object)key);
        return Response.created((URI)new URI("https://camel.apache.org/")).build();
    }

    @Path(value="/issue/{key}/watch")
    @POST
    @Consumes(value={"text/plain"})
    public Response watchIssue(@PathParam(value="key") String key, @QueryParam(value="action") String action, String watchers) {
        List<String> watchList = Collections.singletonList(watchers);
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("IssueKey", key);
        if (action.equals("watch")) {
            headers.put("IssueWatchersAdd", watchList);
        } else if (action.equals("unwatch")) {
            headers.put("IssueWatchersRemove", watchList);
        } else {
            throw new IllegalArgumentException("Unknown watch action: " + action);
        }
        this.producerTemplate.requestBodyAndHeaders("jira:watchers", null, headers);
        return Response.ok().build();
    }

    @Path(value="/issue/link")
    @POST
    public Response linkIssues(@QueryParam(value="parentKey") String parentKey, @QueryParam(value="childKey") String childKey) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("ParentIssueKey", parentKey);
        headers.put("ChildIssueKey", childKey);
        headers.put("linkType", "Related");
        this.producerTemplate.requestBodyAndHeaders("jira:addIssueLink", null, headers);
        return Response.ok().build();
    }

    @Path(value="/issue/{key}/log/work")
    @POST
    @Consumes(value={"text/plain"})
    public Response logWork(@PathParam(value="key") String key, String minutes) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("IssueKey", key);
        headers.put("minutesSpent", Integer.valueOf(minutes));
        this.producerTemplate.requestBodyAndHeaders("jira:addWorkLog", (Object)("Work logged: " + minutes), headers);
        return Response.ok().build();
    }

    @Path(value="/issue/{key}/transition")
    @POST
    @Consumes(value={"text/plain"})
    public Response transition(@PathParam(value="key") String key, String workflowId) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("IssueKey", key);
        headers.put("IssueTransitionId", Integer.valueOf(workflowId));
        this.producerTemplate.requestBodyAndHeaders("jira:transitionIssue", null, headers);
        return Response.ok().build();
    }

    @Path(value="/route/{routeId}/{action}")
    @POST
    public void manageRoute(@PathParam(value="routeId") String routeId, @PathParam(value="action") String action) throws Exception {
        if (action.equals("start")) {
            this.context.getRouteController().startRoute(routeId);
        } else if (action.equals("stop")) {
            this.context.getRouteController().stopRoute(routeId);
        } else {
            throw new IllegalArgumentException("Unknown action: " + action);
        }
    }

    private JsonObject issueToJson(Issue issue) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("description", issue.getDescription());
        builder.add("key", issue.getKey());
        builder.add("summary", issue.getSummary());
        builder.add("type", issue.getIssueType().getName());
        return builder.build();
    }
}

