/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.jira.it;

import com.atlassian.jira.rest.client.api.AuthenticationHandler;
import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.domain.Attachment;
import com.atlassian.jira.rest.client.api.domain.BasicWatchers;
import com.atlassian.jira.rest.client.api.domain.Issue;
import com.atlassian.jira.rest.client.api.domain.IssueLink;
import com.atlassian.jira.rest.client.api.domain.Resolution;
import com.atlassian.jira.rest.client.api.domain.Session;
import com.atlassian.jira.rest.client.api.domain.Worklog;
import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.net.URI;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.camel.component.jira.oauth.JiraOAuthAuthenticationHandler;
import org.apache.camel.component.jira.oauth.OAuthAsynchronousJiraRestClientFactory;
import org.apache.camel.quarkus.component.jira.it.JiraTestResource;
import org.awaitility.Awaitility;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

@QuarkusTest
@QuarkusTestResource(value=JiraTestResource.class)
public class JiraTest {
    private static final String ISSUE_ATTACHMENT = "Camel Quarkus Test Issue Attachment";
    private static final String ISSUE_COMMENT = "Camel Quarkus Test Issue Comment";
    private static final String ISSUE_DESCRIPTION = "Camel Quarkus Test Issue Description";
    private static final String ISSUE_SUMMARY = "Camel Quarkus Test Issue Summary";
    private static final String ISSUE_TYPE = "Task";
    private static final String UPDATED_ISSUE_SUMMARY = "Updated summary";
    private static JiraRestClient REST_CLIENT;

    @BeforeAll
    public static void beforeAll() {
        Config config = ConfigProvider.getConfig();
        String jiraUrl = (String)config.getValue("camel.component.jira.jira-url", String.class);
        Optional username = config.getOptionalValue("camel.component.jira.username", String.class);
        Optional password = config.getOptionalValue("camel.component.jira.password", String.class);
        Optional accessToken = config.getOptionalValue("camel.component.jira.access-token", String.class);
        Optional consumerKey = config.getOptionalValue("camel.component.jira.consumer-key", String.class);
        Optional privateKey = config.getOptionalValue("camel.component.jira.private-key", String.class);
        Optional verificationCode = config.getOptionalValue("camel.component.jira.verification-code", String.class);
        OAuthAsynchronousJiraRestClientFactory factory = new OAuthAsynchronousJiraRestClientFactory();
        URI jiraServerUri = URI.create(jiraUrl);
        if (username.isPresent() && password.isPresent()) {
            REST_CLIENT = factory.createWithBasicHttpAuthentication(jiraServerUri, (String)username.get(), (String)password.get());
        } else if (accessToken.isPresent() && consumerKey.isPresent() && privateKey.isPresent() && verificationCode.isPresent()) {
            JiraOAuthAuthenticationHandler oAuthHandler = new JiraOAuthAuthenticationHandler((String)consumerKey.get(), (String)verificationCode.get(), (String)privateKey.get(), (String)accessToken.get(), jiraUrl);
            REST_CLIENT = factory.create(jiraServerUri, (AuthenticationHandler)oAuthHandler);
        } else {
            throw new IllegalStateException("Unable to create Jira client");
        }
    }

    @Test
    public void issueCrud() {
        ((ValidatableResponse)((Response)RestAssured.given().pathParam("routeId", (Object)"jiraIssues").pathParam("action", (Object)"start").post("/jira/route/{routeId}/{action}", new Object[0])).then()).statusCode(204);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).queryParam("summary", new Object[]{ISSUE_SUMMARY}).queryParam("type", new Object[]{ISSUE_TYPE}).body(ISSUE_DESCRIPTION).when().post("/jira/issue", new Object[0])).then()).statusCode(201)).body("description", Matchers.equalTo((Object)ISSUE_DESCRIPTION), new Object[]{"key", Matchers.matchesPattern((String)"[A-Z]+-[0-9]+"), "summary", Matchers.equalTo((Object)ISSUE_SUMMARY), "type", Matchers.equalTo((Object)ISSUE_TYPE)});
        JsonPath issueJson = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("source", new Object[]{"new"}).get("/jira/issue", new Object[0])).then()).statusCode(200)).body("description", Matchers.equalTo((Object)ISSUE_DESCRIPTION), new Object[]{"key", Matchers.matchesPattern((String)"[A-Z]+-[0-9]+"), "summary", Matchers.equalTo((Object)ISSUE_SUMMARY), "type", Matchers.equalTo((Object)ISSUE_TYPE)})).extract().jsonPath();
        String issueKey = issueJson.getString("key");
        ((ValidatableResponse)((Response)RestAssured.given().pathParam("routeId", (Object)"jiraIssues").pathParam("action", (Object)"stop").post("/jira/route/{routeId}/{action}", new Object[0])).then()).statusCode(204);
        ((ValidatableResponse)((Response)RestAssured.given().pathParam("routeId", (Object)"jiraUpdates").pathParam("action", (Object)"start").post("/jira/route/{routeId}/{action}", new Object[0])).then()).statusCode(204);
        ((ValidatableResponse)((Response)RestAssured.given().pathParam("key", (Object)issueKey).body(UPDATED_ISSUE_SUMMARY).patch("/jira/issue/{key}", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("source", new Object[]{"update"}).get("/jira/issue", new Object[0])).then()).statusCode(200)).body("description", Matchers.equalTo((Object)ISSUE_DESCRIPTION), new Object[]{"key", Matchers.matchesPattern((String)"[A-Z]+-[0-9]+"), "summary", Matchers.equalTo((Object)UPDATED_ISSUE_SUMMARY), "type", Matchers.equalTo((Object)ISSUE_TYPE)});
        ((ValidatableResponse)((Response)RestAssured.given().pathParam("routeId", (Object)"jiraUpdates").pathParam("action", (Object)"stop").post("/jira/route/{routeId}/{action}", new Object[0])).then()).statusCode(204);
        ((ValidatableResponse)((Response)RestAssured.given().pathParam("key", (Object)issueKey).delete("/jira/issue/{key}", new Object[0])).then()).statusCode(204);
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).pollDelay(1L, TimeUnit.SECONDS).until(() -> ((ValidatableResponse)((Response)RestAssured.given().pathParam("key", (Object)issueKey).get("/jira/issue/{key}", new Object[0])).then()).extract().statusCode() == 404);
    }

    @Test
    public void comments() {
        String issueKey = this.createIssue();
        try {
            ((ValidatableResponse)((Response)RestAssured.given().pathParam("routeId", (Object)"jiraComments").pathParam("action", (Object)"start").post("/jira/route/{routeId}/{action}", new Object[0])).then()).statusCode(204);
            ((ValidatableResponse)((Response)RestAssured.given().pathParam("key", (Object)issueKey).body(ISSUE_COMMENT).post("/jira/issue/{key}/comment", new Object[0])).then()).statusCode(201);
            ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/jira/issue/comment", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.equalTo((Object)ISSUE_COMMENT), new Matcher[0]);
            ((ValidatableResponse)((Response)RestAssured.given().pathParam("routeId", (Object)"jiraComments").pathParam("action", (Object)"stop").post("/jira/route/{routeId}/{action}", new Object[0])).then()).statusCode(204);
        }
        finally {
            this.deleteIssue(issueKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void attachments() {
        String issueKey = this.createIssue();
        try {
            ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).pathParam("key", (Object)issueKey).body(ISSUE_ATTACHMENT).when().post("/jira/issue/{key}/attach", new Object[0])).then()).statusCode(201);
            Awaitility.await().atMost(10L, TimeUnit.SECONDS).pollDelay(1L, TimeUnit.SECONDS).until(() -> {
                Issue issue = (Issue)JiraTest.getClient().getIssueClient().getIssue(issueKey).claim();
                Assertions.assertNotNull((Object)issue);
                Iterable iterable = issue.getAttachments();
                return iterable != null && iterable.iterator().hasNext();
            });
            Issue issue = (Issue)JiraTest.getClient().getIssueClient().getIssue(issueKey).claim();
            Attachment attachment = (Attachment)issue.getAttachments().iterator().next();
            Assertions.assertTrue((boolean)attachment.getFilename().startsWith("cq-jira"));
        }
        finally {
            this.deleteIssue(issueKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void watchers() {
        String issueKey = this.createIssue();
        try {
            JiraRestClient client = JiraTest.getClient();
            String username = ((Session)client.getSessionClient().getCurrentSession().claim()).getUsername();
            ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).pathParam("key", (Object)issueKey).queryParam("action", new Object[]{"unwatch"}).body(username).when().post("/jira/issue/{key}/watch", new Object[0])).then()).statusCode(200);
            Awaitility.await().atMost(10L, TimeUnit.SECONDS).pollDelay(1L, TimeUnit.SECONDS).until(() -> {
                Issue issue = (Issue)JiraTest.getClient().getIssueClient().getIssue(issueKey).claim();
                Assertions.assertNotNull((Object)issue);
                BasicWatchers watchers = issue.getWatchers();
                return watchers != null && !watchers.isWatching();
            });
            ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).pathParam("key", (Object)issueKey).queryParam("action", new Object[]{"watch"}).body(username).when().post("/jira/issue/{key}/watch", new Object[0])).then()).statusCode(200);
            Awaitility.await().atMost(10L, TimeUnit.SECONDS).pollDelay(1L, TimeUnit.SECONDS).until(() -> {
                Issue issue = (Issue)JiraTest.getClient().getIssueClient().getIssue(issueKey).claim();
                Assertions.assertNotNull((Object)issue);
                BasicWatchers watchers = issue.getWatchers();
                return watchers != null && watchers.isWatching();
            });
        }
        finally {
            this.deleteIssue(issueKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void issueLinks() {
        ArrayList<String> issueKeys = new ArrayList<String>();
        for (int i = 0; i < 2; ++i) {
            issueKeys.add(this.createIssue());
        }
        try {
            String parentKey = (String)issueKeys.get(0);
            String childKey = (String)issueKeys.get(1);
            ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).queryParam("parentKey", new Object[]{parentKey}).queryParam("childKey", new Object[]{childKey}).when().post("/jira/issue/link", new Object[0])).then()).statusCode(200);
            Awaitility.await().atMost(10L, TimeUnit.SECONDS).pollDelay(1L, TimeUnit.SECONDS).until(() -> {
                Issue parent = (Issue)JiraTest.getClient().getIssueClient().getIssue(parentKey).claim();
                Assertions.assertNotNull((Object)parent);
                Iterable issueLinks = parent.getIssueLinks();
                Assertions.assertNotNull((Object)issueLinks);
                IssueLink link = (IssueLink)issueLinks.iterator().next();
                Assertions.assertNotNull((Object)link);
                return childKey.equals(link.getTargetIssueKey());
            });
        }
        finally {
            issueKeys.forEach(this::deleteIssue);
        }
    }

    @Test
    public void workLog() {
        String issueKey = this.createIssue();
        try {
            ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).pathParam("key", (Object)issueKey).body("30").when().post("/jira/issue/{key}/log/work", new Object[0])).then()).statusCode(200);
            Awaitility.await().atMost(10L, TimeUnit.SECONDS).pollDelay(1L, TimeUnit.SECONDS).until(() -> {
                Issue issue = (Issue)JiraTest.getClient().getIssueClient().getIssue(issueKey).claim();
                Assertions.assertNotNull((Object)issue);
                Iterable workLogs = issue.getWorklogs();
                Assertions.assertNotNull((Object)workLogs);
                Worklog workLog = (Worklog)workLogs.iterator().next();
                Assertions.assertNotNull((Object)workLog);
                return workLog.getMinutesSpent() == 30 && workLog.getComment().equals("Work logged: 30");
            });
        }
        finally {
            this.deleteIssue(issueKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void workflowTransition() {
        String issueKey = this.createIssue();
        try {
            Issue originalIssue = (Issue)JiraTest.getClient().getIssueClient().getIssue(issueKey).claim();
            Assertions.assertNotNull((Object)originalIssue);
            Resolution originalResolution = originalIssue.getResolution();
            Assertions.assertNull((Object)originalResolution);
            String transitionId = System.getenv("JIRA_TRANSITION_ID");
            if (transitionId == null) {
                transitionId = "31";
            }
            ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).pathParam("key", (Object)issueKey).body(transitionId).when().post("/jira/issue/{key}/transition", new Object[0])).then()).statusCode(200);
            Awaitility.await().atMost(10L, TimeUnit.SECONDS).pollDelay(1L, TimeUnit.SECONDS).until(() -> {
                Issue issue = (Issue)JiraTest.getClient().getIssueClient().getIssue(issueKey).claim();
                Assertions.assertNotNull((Object)issue);
                Resolution resolution = issue.getResolution();
                return resolution != null;
            });
        }
        finally {
            this.deleteIssue(issueKey);
        }
    }

    private String createIssue() {
        return ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).queryParam("summary", new Object[]{ISSUE_SUMMARY}).queryParam("type", new Object[]{ISSUE_TYPE}).body(ISSUE_DESCRIPTION).when().post("/jira/issue", new Object[0])).then()).statusCode(201)).body("description", Matchers.equalTo((Object)ISSUE_DESCRIPTION), new Object[]{"key", Matchers.matchesPattern((String)"[A-Z]+-[0-9]+"), "summary", Matchers.equalTo((Object)ISSUE_SUMMARY), "type", Matchers.equalTo((Object)ISSUE_TYPE)})).extract().jsonPath().getString("key");
    }

    private void deleteIssue(String issueKey) {
        try {
            JiraTest.getClient().getIssueClient().deleteIssue(issueKey, true).claim();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static JiraRestClient getClient() {
        if (REST_CLIENT == null) {
            Config config = ConfigProvider.getConfig();
            String jiraUrl = (String)config.getValue("camel.component.jira.jira-url", String.class);
            Optional username = config.getOptionalValue("camel.component.jira.username", String.class);
            Optional password = config.getOptionalValue("camel.component.jira.password", String.class);
            OAuthAsynchronousJiraRestClientFactory factory = new OAuthAsynchronousJiraRestClientFactory();
            URI jiraServerUri = URI.create(jiraUrl);
            if (username.isPresent() && password.isPresent()) {
                return factory.createWithBasicHttpAuthentication(jiraServerUri, (String)username.get(), (String)password.get());
            }
            throw new IllegalStateException("Unable to create Jira client");
        }
        return REST_CLIENT;
    }
}

