/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.jira.it;

import java.util.Map;
import org.apache.camel.quarkus.test.wiremock.WireMockTestResourceLifecycleManager;

public class JiraTestResource
extends WireMockTestResourceLifecycleManager {
    private static final String JIRA_ENV_URL = "JIRA_URL";
    private static final String JIRA_ENV_USERNAME = "JIRA_USERNAME";
    private static final String JIRA_ENV_PASSWORD = "JIRA_PASSWORD";
    private static final String JIRA_ENV_ISSUES_PROJECT_KEY = "JIRA_ISSUES_PROJECT_KEY";
    private static final String JIRA_ENV_OAUTH_ACCESS_TOKEN = "JIRA_OAUTH_ACCESS_TOKEN";
    private static final String JIRA_ENV_OAUTH_CONSUMER_KEY = "JIRA_OAUTH_CONSUMER_KEY";
    private static final String JIRA_ENV_OAUTH_PRIVATE_KEY = "JIRA_OAUTH_PRIVATE_KEY";
    private static final String JIRA_ENV_OAUTH_VERIFICATION_CODE = "JIRA_OAUTH_VERIFICATION_CODE";

    public Map<String, String> start() {
        Map options = super.start();
        String jiraUrl = this.envOrDefault(JIRA_ENV_URL, "http://localhost:8080");
        if (options.containsKey("wiremock.url")) {
            jiraUrl = (String)options.get("wiremock.url");
        }
        options.put("jira.issues.project-key", this.envOrDefault(JIRA_ENV_ISSUES_PROJECT_KEY, "TEST"));
        options.put("camel.component.jira.jira-url", jiraUrl);
        if (this.isOauth()) {
            options.put("camel.component.jira.access-token", this.envOrDefault(JIRA_ENV_OAUTH_ACCESS_TOKEN, ""));
            options.put("camel.component.jira.consumer-key", this.envOrDefault(JIRA_ENV_OAUTH_CONSUMER_KEY, ""));
            options.put("camel.component.jira.private-key", this.envOrDefault(JIRA_ENV_OAUTH_PRIVATE_KEY, ""));
            options.put("camel.component.jira.verification-code", this.envOrDefault(JIRA_ENV_OAUTH_VERIFICATION_CODE, ""));
        } else {
            options.put("camel.component.jira.username", this.envOrDefault(JIRA_ENV_USERNAME, "jiratester"));
            options.put("camel.component.jira.password", this.envOrDefault(JIRA_ENV_PASSWORD, "tester123"));
        }
        return options;
    }

    protected String getRecordTargetBaseUrl() {
        return this.envOrDefault(JIRA_ENV_URL, null);
    }

    protected boolean isMockingEnabled() {
        if (this.isOauth()) {
            return !this.envVarsPresent(new String[]{JIRA_ENV_URL, JIRA_ENV_ISSUES_PROJECT_KEY, JIRA_ENV_OAUTH_ACCESS_TOKEN, JIRA_ENV_OAUTH_CONSUMER_KEY, JIRA_ENV_OAUTH_PRIVATE_KEY, JIRA_ENV_OAUTH_VERIFICATION_CODE});
        }
        return !this.envVarsPresent(new String[]{JIRA_ENV_URL, JIRA_ENV_USERNAME, JIRA_ENV_PASSWORD, JIRA_ENV_ISSUES_PROJECT_KEY});
    }

    private boolean isOauth() {
        return this.envVarsPresent(new String[]{JIRA_ENV_OAUTH_ACCESS_TOKEN, JIRA_ENV_OAUTH_CONSUMER_KEY, JIRA_ENV_OAUTH_PRIVATE_KEY, JIRA_ENV_OAUTH_VERIFICATION_CODE});
    }
}

