/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.jira.it;

import com.atlassian.jira.rest.client.api.domain.Issue;
import java.net.URI;
import java.util.HashMap;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.camel.ProducerTemplate;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.logging.Logger;

@Path(value="/jira")
public class JiraResource {
    private static final Logger log = Logger.getLogger(JiraResource.class);
    @Inject
    ProducerTemplate producerTemplate;
    @ConfigProperty(name="jira.issues.project-key")
    String projectKey;

    @Path(value="/post")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response post(@QueryParam(value="jiraUrl") String jiraUrl, String message) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("ProjectKey", this.projectKey);
        headers.put("IssueTypeName", "Task");
        headers.put("IssueSummary", "Demo Bug");
        log.infof("Sending to jira: %s", (Object)message);
        Issue issue = (Issue)this.producerTemplate.requestBodyAndHeaders("jira:addIssue?jiraUrl=" + jiraUrl, (Object)message, headers, Issue.class);
        log.infof("Created new issue: %s", (Object)issue.getKey());
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)issue.getKey()).status(201).build();
    }
}

