/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.jdbc;

import jakarta.enterprise.context.ApplicationScoped;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
public class JdbcRoutes
extends RouteBuilder {
    @ConfigProperty(name="quarkus.datasource.cameldb.db-kind")
    String dbKind;

    public void configure() {
        ((RouteDefinition)this.from("direct://get-generated-keys").to("jdbc:cameldb")).process(new Processor(){

            public void process(Exchange exchange) throws Exception {
                System.out.println(exchange.getIn().getHeaders());
                Object in = exchange.getIn().getHeader("CamelGeneratedKeysRows");
                exchange.getIn().setBody(in);
            }
        });
        ((RouteDefinition)this.from("direct://get-headers").to("jdbc:cameldb")).process(new Processor(){

            public void process(Exchange exchange) throws Exception {
                Map in = exchange.getIn().getHeaders();
                exchange.getIn().setBody((Object)in);
            }
        });
        this.from("direct://headers-as-parameters").to("jdbc:cameldb?useHeadersAsParameters=true");
        ((RouteDefinition)((RouteDefinition)this.from("timer://interval-polling?delay=2000&repeatCount=1").routeId("jdbc-poll").autoStartup(false).setBody((Expression)this.constant("select * from camelsGenerated order by id desc"))).to("jdbc:cameldb")).to("mock:interval-polling");
        String species = this.dbKind.equals("postgresql") || this.dbKind.equals("mysql") || this.dbKind.equals("mariadb") || this.dbKind.equals("mssql") ? "species" : "SPECIES";
        ((ExpressionNode)((RouteDefinition)((RouteDefinition)this.from("direct://move-between-datasources").setBody((Expression)this.constant("select * from camels"))).to("jdbc:cameldb")).split((Expression)this.body()).setBody((Expression)this.simple("insert into camelsProcessed (species) values('${body[" + species + "]}')"))).to("jdbc:cameldb");
    }
}

