/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.jdbc;

import io.agroal.api.AgroalDataSource;
import io.quarkus.agroal.DataSource;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.quarkus.component.jdbc.model.Camel;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/test")
@ApplicationScoped
public class CamelResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(CamelResource.class);
    @Inject
    @DataSource(value="cameldb")
    AgroalDataSource dataSource;
    @Inject
    ProducerTemplate template;
    @Inject
    CamelContext context;
    @ConfigProperty(name="quarkus.datasource.cameldb.db-kind")
    String dbKind;

    @PostConstruct
    void postConstruct() throws Exception {
        Connection conn = this.dataSource.getConnection();
        this.runScripts(conn, "droptables.sql");
        this.runScripts(conn, this.dbKind + ".sql");
        this.runScripts(conn, "inserts.sql");
        this.context.getRouteController().startRoute("jdbc-poll");
    }

    @Path(value="/species/{id}")
    @GET
    @Produces(value={"text/plain"})
    public String getSpeciesById(@PathParam(value="id") String id) throws Exception {
        return (String)this.template.requestBody("jdbc:cameldb", (Object)("select species from camels where id = " + id), String.class);
    }

    @Path(value="/species/{id}/list")
    @GET
    @Produces(value={"text/plain"})
    public String getSpeciesByIdWithSelectList(@PathParam(value="id") String id) throws Exception {
        List result = (List)this.template.requestBody("jdbc:cameldb?outputType=SelectList", (Object)("select * from camels where id = " + id), List.class);
        if (result.isEmpty()) {
            throw new IllegalStateException("Expected at least 1 camel result but none were found");
        }
        LinkedHashMap data = (LinkedHashMap)result.get(0);
        return data.get(this.getSpeciesRowName()) + " " + data.get(this.getIdRowName());
    }

    @Path(value="/species/{id}/type")
    @GET
    @Produces(value={"text/plain"})
    public String getSpeciesByIdWithDefinedType(@PathParam(value="id") String id) throws Exception {
        List results = (List)this.template.requestBody("jdbc:cameldb?outputClass=" + Camel.class.getName(), (Object)("select * from camels where id = " + id), List.class);
        if (results.isEmpty()) {
            throw new IllegalStateException("Expected at least 1 camel result but none were found");
        }
        Camel camel = (Camel)results.get(0);
        return camel.getSpecies() + " " + camel.getId();
    }

    @Path(value="/execute")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String executeStatement(String statement) throws Exception {
        return (String)this.template.requestBody("jdbc:cameldb", (Object)statement, String.class);
    }

    @Path(value="/generated-keys/rows")
    @GET
    @Produces(value={"application/json"})
    public List generatedKeysRows() throws Exception {
        return (List)this.template.requestBodyAndHeader("direct://get-generated-keys", (Object)"insert into camelsGenerated (species) values ('Camelus testus')", "CamelRetrieveGeneratedKeys", (Object)"true", ArrayList.class);
    }

    @Path(value="/headers/insert")
    @GET
    @Produces(value={"application/json"})
    public String headersFromInsertOrUpdate() throws Exception {
        return (String)this.template.requestBodyAndHeader("direct://get-headers", (Object)"insert into camelsGenerated (species) values ('Camelus testus')", "CamelRetrieveGeneratedKeys", (Object)"true", String.class);
    }

    @Path(value="/headers/select")
    @GET
    @Produces(value={"application/json"})
    public String headersFromSelect() throws Exception {
        return (String)this.template.requestBody("direct://get-headers", (Object)"select * from camelsGenerated", String.class);
    }

    @Path(value="/named-parameters/headers-as-parameters")
    @GET
    @Produces(value={"application/json"})
    public String headersAsParameters() throws Exception {
        int id = 3;
        return (String)this.template.requestBodyAndHeader("direct://headers-as-parameters", (Object)"select * from camels where id < :?idmax order by id", "idmax", (Object)id, String.class);
    }

    @Path(value="/named-parameters/headers-as-parameters-map")
    @GET
    @Produces(value={"application/json"})
    public String headersAsParametersMap() throws Exception {
        Map<String, String> headersMap = Map.of("idmax", 3, "specs", "Camelus bactrianus");
        return (String)this.template.requestBodyAndHeader("direct://headers-as-parameters", (Object)"select * from camels where id < :?idmax and species = :?specs order by id", "CamelJdbcParameters", headersMap, String.class);
    }

    @Path(value="/interval-polling")
    @GET
    @Produces(value={"application/json"})
    public void intervalPolling(String selectResult) throws Exception {
        MockEndpoint mockEndpoint = (MockEndpoint)this.context.getEndpoint("mock:interval-polling", MockEndpoint.class);
        mockEndpoint.expectedBodiesReceived(new Object[]{selectResult});
        mockEndpoint.assertIsSatisfied();
    }

    @Path(value="/move-between-datasources")
    @POST
    @Produces(value={"application/json"})
    public String moveBetweenDatasources() throws Exception {
        return (String)this.template.requestBody("direct://move-between-datasources", null, String.class);
    }

    private void runScripts(Connection conn, String fileName) throws SQLException, IOException {
        try (Statement statement = conn.createStatement();
             InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("sql/" + fileName);
             InputStreamReader isr = new InputStreamReader(is);
             BufferedReader reader = new BufferedReader(isr);){
            reader.lines().filter(s -> s != null && !"".equals(s) && !s.startsWith("--")).forEach(s -> {
                try {
                    statement.execute((String)s);
                }
                catch (SQLException e) {
                    if (!s.toUpperCase().startsWith("DROP")) {
                        throw new RuntimeException(e);
                    }
                    LOGGER.debug(String.format("Command '%s' failed.", s));
                }
            });
        }
    }

    @Path(value="/get-id-key")
    @GET
    @Produces(value={"text/plain"})
    public String getIdKey() {
        switch (this.dbKind) {
            case "postgresql": {
                return "id";
            }
            case "oracle": {
                return "ROWID";
            }
            case "mssql": {
                return "GENERATED_KEYS";
            }
            case "mariadb": {
                return "insert_id";
            }
            case "mysql": {
                return "GENERATED_KEY";
            }
        }
        return "ID";
    }

    private String getIdRowName() {
        if (this.dbKind.equals("h2") || this.dbKind.equals("oracle") || this.dbKind.equals("db2")) {
            return "ID";
        }
        return "id";
    }

    private String getSpeciesRowName() {
        if (this.dbKind.equals("h2") || this.dbKind.equals("oracle") || this.dbKind.equals("db2")) {
            return "SPECIES";
        }
        return "species";
    }
}

