/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.jdbc;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.h2.H2DatabaseTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

@QuarkusTest
@QuarkusTestResource(value=H2DatabaseTestResource.class)
public class CamelJdbcTest {
    @Test
    void testGetSpeciesById() {
        ((ValidatableResponse)((Response)RestAssured.when().get("/test/species/1", new Object[0])).then()).body(Matchers.is((Object)"[{SPECIES=Camelus dromedarius}]"), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.when().get("/test/species/2", new Object[0])).then()).body(Matchers.is((Object)"[{SPECIES=Camelus bactrianus}]"), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.when().get("/test/species/3", new Object[0])).then()).body(Matchers.is((Object)"[{SPECIES=Camelus ferus}]"), new Matcher[0]);
    }

    @Test
    void testGetSpeciesByIdWithResultList() {
        ((ValidatableResponse)((Response)RestAssured.when().get("/test/species/1/list", new Object[0])).then()).body(Matchers.is((Object)"Camelus dromedarius 1"), new Matcher[0]);
    }

    @Test
    void testGetSpeciesByIdWithDefinedType() {
        ((ValidatableResponse)((Response)RestAssured.when().get("/test/species/1/type", new Object[0])).then()).body(Matchers.is((Object)"Camelus dromedarius 1"), new Matcher[0]);
    }

    @Test
    void testExecuteStatement() {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("select id from camels order by id desc").post("/test/execute", new Object[0])).then()).body(Matchers.is((Object)"[{ID=3}, {ID=2}, {ID=1}]"), new Matcher[0]);
    }
}

