/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.jdbc;

import io.agroal.api.AgroalDataSource;
import io.quarkus.agroal.DataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.quarkus.component.jdbc.model.Camel;

@Path(value="/test")
@ApplicationScoped
public class CamelResource {
    @Inject
    @DataSource(value="camel-ds")
    AgroalDataSource dataSource;
    @Inject
    ProducerTemplate template;

    @PostConstruct
    void postConstruct() throws SQLException {
        try (Connection con = this.dataSource.getConnection();
             Statement statement = con.createStatement();){
            try {
                statement.execute("drop table camels");
            }
            catch (Exception exception) {
                // empty catch block
            }
            statement.execute("create table camels (id int primary key, species varchar(255))");
            statement.execute("insert into camels (id, species) values (1, 'Camelus dromedarius')");
            statement.execute("insert into camels (id, species) values (2, 'Camelus bactrianus')");
            statement.execute("insert into camels (id, species) values (3, 'Camelus ferus')");
        }
    }

    @Path(value="/species/{id}")
    @GET
    @Produces(value={"text/plain"})
    public String getSpeciesById(@PathParam(value="id") String id) throws Exception {
        return (String)this.template.requestBody("jdbc:camel-ds", (Object)("select species from camels where id = " + id), String.class);
    }

    @Path(value="/species/{id}/list")
    @GET
    @Produces(value={"text/plain"})
    public String getSpeciesByIdWithSelectList(@PathParam(value="id") String id) throws Exception {
        List result = (List)this.template.requestBody("jdbc:camel-ds?outputType=SelectList", (Object)("select * from camels where id = " + id), List.class);
        if (result.isEmpty()) {
            throw new IllegalStateException("Expected at least 1 camel result but none were found");
        }
        LinkedHashMap data = (LinkedHashMap)result.get(0);
        return data.get("SPECIES") + " " + data.get("ID");
    }

    @Path(value="/species/{id}/type")
    @GET
    @Produces(value={"text/plain"})
    public String getSpeciesByIdWithDefinedType(@PathParam(value="id") String id) throws Exception {
        List results = (List)this.template.requestBody("jdbc:camel-ds?outputClass=" + Camel.class.getName(), (Object)("select * from camels where id = " + id), List.class);
        if (results.isEmpty()) {
            throw new IllegalStateException("Expected at least 1 camel result but none were found");
        }
        Camel camel = (Camel)results.get(0);
        return camel.getSpecies() + " " + camel.getId();
    }

    @Path(value="/execute")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String executeStatement(String statement) throws Exception {
        return (String)this.template.requestBody("jdbc:camel-ds", (Object)statement, String.class);
    }
}

