/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.jdbc;

import io.agroal.api.AgroalDataSource;
import io.quarkus.agroal.DataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.camel.ProducerTemplate;

@Path(value="/test")
@ApplicationScoped
public class CamelResource {
    @Inject
    @DataSource(value="camel-ds")
    AgroalDataSource dataSource;
    @Inject
    ProducerTemplate template;

    @PostConstruct
    void postConstruct() throws SQLException {
        try (Connection con = this.dataSource.getConnection();
             Statement statement = con.createStatement();){
            try {
                statement.execute("drop table camels");
            }
            catch (Exception exception) {
                // empty catch block
            }
            statement.execute("create table camels (id int primary key, species varchar(255))");
            statement.execute("insert into camels (id, species) values (1, 'Camelus dromedarius')");
            statement.execute("insert into camels (id, species) values (2, 'Camelus bactrianus')");
            statement.execute("insert into camels (id, species) values (3, 'Camelus ferus')");
        }
    }

    @Path(value="/species/{id}")
    @GET
    @Produces(value={"text/plain"})
    public String getSpeciesById(@PathParam(value="id") String id) throws Exception {
        return (String)this.template.requestBody("direct:execute", (Object)("select species from camels where id = " + id), String.class);
    }

    @Path(value="/execute")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String executeStatement(String statement) throws Exception {
        return (String)this.template.requestBody("direct:execute", (Object)statement, String.class);
    }
}

