/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.jcache.it;

import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.CreatedExpiryPolicy;
import javax.cache.expiry.Duration;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.jcache.policy.JCachePolicy;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Policy;

@ApplicationScoped
public class JcacheRoutes
extends RouteBuilder {
    @Inject
    @Named(value="jcachePolicy")
    JCachePolicy jcachePolicy;

    public void configure() throws Exception {
        ((PolicyDefinition)((PolicyDefinition)((RouteDefinition)this.from("direct:getCachedValue").setProperty("In-Cache", (Expression)this.constant("Cached Response"))).policy((Policy)this.jcachePolicy).setBody((Expression)this.constant("Hello World"))).setProperty("In-Cache", (Expression)this.constant("Non-Cached Response"))).end();
    }

    @Produces
    @ApplicationScoped
    @Named
    public JCachePolicy jcachePolicy() {
        MutableConfiguration configuration = new MutableConfiguration();
        configuration.setTypes(String.class, Object.class);
        configuration.setExpiryPolicyFactory(CreatedExpiryPolicy.factoryOf((Duration)new Duration(TimeUnit.SECONDS, 3L)));
        CacheManager cacheManager = Caching.getCachingProvider().getCacheManager();
        Cache cache = cacheManager.createCache("MyJCache", (Configuration)configuration);
        JCachePolicy jcachePolicy = new JCachePolicy();
        jcachePolicy.setCache(cache);
        jcachePolicy.setKeyExpression((Expression)this.simple("${header.Cache-Key}"));
        return jcachePolicy;
    }
}

