/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.jaxb.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.config.XmlConfig;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.camel.quarkus.component.jaxb.it.model.Person;
import org.apache.camel.quarkus.component.jaxb.it.model.namespaced.NamespacedPerson;
import org.apache.camel.quarkus.component.jaxb.it.model.simple.SimplePerson;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@QuarkusTest
class JaxbTest {
    private static final String PERSON_FIRST_NAME = "John";
    private static final String PERSON_LAST_NAME = "Doe";
    private static final int PERSON_AGE = 25;

    JaxbTest() {
    }

    @Test
    public void marshall() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("firstName", new Object[]{PERSON_FIRST_NAME}).queryParam("lastName", new Object[]{PERSON_LAST_NAME}).queryParam("age", new Object[]{25}).get("/jaxb/marshal", new Object[0])).then()).statusCode(200)).body("person.firstName", Matchers.is((Object)PERSON_FIRST_NAME), new Object[]{"person.lastName", Matchers.is((Object)PERSON_LAST_NAME), "person.age", Matchers.is((Object)String.valueOf(25))});
    }

    @Test
    public void unmarshall() {
        SimplePerson person = new SimplePerson();
        person.setFirstName(PERSON_FIRST_NAME);
        person.setLastName(PERSON_LAST_NAME);
        person.setAge(Integer.valueOf(25));
        String xml = JaxbTest.getPersonXml((Person)person);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.XML).body(xml).post("/jaxb/unmarshal", new Object[0])).then()).statusCode(200)).body("firstName", Matchers.is((Object)PERSON_FIRST_NAME), new Object[]{"lastName", Matchers.is((Object)PERSON_LAST_NAME), "age", Matchers.is((Object)25)});
    }

    @Test
    public void marshallWithoutMandatoryField() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("firstName", new Object[]{PERSON_FIRST_NAME}).queryParam("age", new Object[]{25}).get("/jaxb/marshal", new Object[0])).then()).statusCode(500)).body("error", Matchers.containsString((String)"'{lastName}'"), new Object[0]);
    }

    @Test
    public void unmarshallWithoutMandatoryField() {
        SimplePerson person = new SimplePerson();
        person.setFirstName(PERSON_FIRST_NAME);
        person.setAge(Integer.valueOf(25));
        String xml = JaxbTest.getPersonXml((Person)person);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.XML).body(xml).post("/jaxb/unmarshal", new Object[0])).then()).statusCode(500)).body("error", Matchers.containsString((String)"'{lastName}'"), new Object[0]);
    }

    @Test
    public void marshallWithJaxbDsl() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("firstName", new Object[]{PERSON_FIRST_NAME}).queryParam("lastName", new Object[]{PERSON_LAST_NAME}).queryParam("age", new Object[]{25}).get("/jaxb/marshal/dsl", new Object[0])).then()).statusCode(200)).body("person.firstName", Matchers.is((Object)PERSON_FIRST_NAME), new Object[]{"person.lastName", Matchers.is((Object)PERSON_LAST_NAME), "person.age", Matchers.is((Object)String.valueOf(25))});
    }

    @Test
    public void unmarshallWithJaxbDsl() {
        SimplePerson person = new SimplePerson();
        person.setFirstName(PERSON_FIRST_NAME);
        person.setLastName(PERSON_LAST_NAME);
        person.setAge(Integer.valueOf(25));
        String xml = JaxbTest.getPersonXml((Person)person);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.XML).body(xml).post("/jaxb/unmarshal/dsl", new Object[0])).then()).statusCode(200)).body("firstName", Matchers.is((Object)PERSON_FIRST_NAME), new Object[]{"lastName", Matchers.is((Object)PERSON_LAST_NAME), "age", Matchers.is((Object)25)});
    }

    @Test
    public void marshallWithNamespacePrefix() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().config(RestAssured.config().xmlConfig(XmlConfig.xmlConfig().declareNamespace("test", "https://example.com/a"))).queryParam("firstName", new Object[]{PERSON_FIRST_NAME}).queryParam("lastName", new Object[]{PERSON_LAST_NAME}).queryParam("age", new Object[]{25}).get("/jaxb/marshal/namespace/prefix", new Object[0])).then()).statusCode(200)).body("person.firstName", Matchers.is((Object)PERSON_FIRST_NAME), new Object[]{"person.lastName", Matchers.is((Object)PERSON_LAST_NAME), "person.age", Matchers.is((Object)String.valueOf(25))});
    }

    @Test
    public void unmarshallWithNamespacePrefix() {
        NamespacedPerson person = new NamespacedPerson();
        person.setFirstName(PERSON_FIRST_NAME);
        person.setLastName(PERSON_LAST_NAME);
        person.setAge(Integer.valueOf(25));
        String xml = JaxbTest.getPersonXml((Person)person);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.XML).body(xml).post("/jaxb/unmarshal/namespace/prefix", new Object[0])).then()).statusCode(200)).body("firstName", Matchers.is((Object)PERSON_FIRST_NAME), new Object[]{"lastName", Matchers.is((Object)PERSON_LAST_NAME), "age", Matchers.is((Object)25)});
    }

    @Test
    public void marshallWithEncoding() {
        String firstName = PERSON_FIRST_NAME.replace("o", "\u00f8");
        String lastName = "Doe \ud83d\udc33";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).queryParam("firstName", new Object[]{firstName}).queryParam("lastName", new Object[]{lastName}).queryParam("age", new Object[]{25}).get("/jaxb/marshal/encoding", new Object[0])).then()).statusCode(200)).body("person.firstName", Matchers.endsWith((String)firstName), new Object[]{"person.lastName", Matchers.is((Object)"Doe   "), "person.age", Matchers.is((Object)String.valueOf(25))});
    }

    @Test
    public void unmarshallWithEncoding() {
        String firstName = PERSON_FIRST_NAME.replace("o", "\u00f8");
        SimplePerson person = new SimplePerson();
        person.setFirstName(firstName);
        person.setLastName(PERSON_LAST_NAME);
        person.setAge(Integer.valueOf(25));
        String xml = JaxbTest.getPersonXml((Person)person, "ISO-8859-1");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.XML).body(xml).post("/jaxb/unmarshal/encoding", new Object[0])).then()).statusCode(200)).body("firstName", Matchers.is((Object)firstName), new Object[]{"lastName", Matchers.is((Object)PERSON_LAST_NAME), "age", Matchers.is((Object)25)});
    }

    @Test
    public void marshalWithExistingXmlPayload() {
        SimplePerson person = new SimplePerson();
        person.setFirstName(PERSON_FIRST_NAME);
        person.setLastName(PERSON_LAST_NAME);
        person.setAge(Integer.valueOf(25));
        String xml = JaxbTest.getPersonXml((Person)person);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.XML).body(xml).post("/jaxb/marshal/xml", new Object[0])).then()).statusCode(200)).body("person.firstName", Matchers.is((Object)PERSON_FIRST_NAME), new Object[]{"person.lastName", Matchers.is((Object)PERSON_LAST_NAME), "person.age", Matchers.is((Object)String.valueOf(25))});
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void marshalWithPartClass(boolean useHeader) {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("firstName", new Object[]{PERSON_FIRST_NAME}).queryParam("lastName", new Object[]{PERSON_LAST_NAME}).queryParam("age", new Object[]{25}).queryParam("useHeader", new Object[]{useHeader}).get("/jaxb/marshal/part/class", new Object[0])).then()).statusCode(200)).body("person.firstName", Matchers.is((Object)PERSON_FIRST_NAME), new Object[]{"person.lastName", Matchers.is((Object)PERSON_LAST_NAME), "person.age", Matchers.is((Object)String.valueOf(25))});
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void unmarshalWithPartClass(boolean useHeader) {
        String personXml = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("firstName", new Object[]{PERSON_FIRST_NAME}).queryParam("lastName", new Object[]{PERSON_LAST_NAME}).queryParam("age", new Object[]{25}).queryParam("useHeader", new Object[]{useHeader}).get("/jaxb/marshal/part/class", new Object[0])).then()).statusCode(200)).extract().body().asString();
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("useHeader", new Object[]{useHeader}).contentType(ContentType.XML).body(personXml).post("/jaxb/unmarshal/part/class", new Object[0])).then()).statusCode(200)).body("firstName", Matchers.is((Object)PERSON_FIRST_NAME), new Object[]{"lastName", Matchers.is((Object)PERSON_LAST_NAME), "age", Matchers.is((Object)25)});
    }

    @Test
    public void unmarshalWithIgnoreJaxbElement() {
        String personXml = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("firstName", new Object[]{PERSON_FIRST_NAME}).queryParam("lastName", new Object[]{PERSON_LAST_NAME}).queryParam("age", new Object[]{25}).queryParam("useHeader", new Object[]{false}).get("/jaxb/marshal/part/class", new Object[0])).then()).statusCode(200)).extract().body().asString();
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.XML).body(personXml).post("/jaxb/unmarshal/ignore/element", new Object[0])).then()).statusCode(200)).body("firstName", Matchers.is((Object)PERSON_FIRST_NAME), new Object[]{"lastName", Matchers.is((Object)PERSON_LAST_NAME), "age", Matchers.is((Object)25)});
    }

    @Test
    public void marshallWithCustomProperties() {
        String[] lines = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("firstName", new Object[]{PERSON_FIRST_NAME}).queryParam("lastName", new Object[]{PERSON_LAST_NAME}).queryParam("age", new Object[]{25}).get("/jaxb/marshal/custom/properties", new Object[0])).then()).statusCode(200)).extract().body().asString().split(System.lineSeparator());
        Assertions.assertEquals((int)1, (int)lines.length);
    }

    @Test
    public void marshalWithCustomStreamWriter() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("firstName", new Object[]{PERSON_FIRST_NAME}).queryParam("lastName", new Object[]{PERSON_LAST_NAME}).queryParam("age", new Object[]{25}).get("/jaxb/marshal/custom/stream/writer", new Object[0])).then()).statusCode(200)).body("person-modified.firstName-modified", Matchers.is((Object)PERSON_FIRST_NAME), new Object[]{"person-modified.lastName-modified", Matchers.is((Object)PERSON_LAST_NAME), "person-modified.age-modified", Matchers.is((Object)String.valueOf(25))});
    }

    @Test
    public void marshalWithObjectFactory() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("firstName", new Object[]{PERSON_FIRST_NAME}).queryParam("lastName", new Object[]{PERSON_LAST_NAME}).queryParam("age", new Object[]{25}).get("/jaxb/marshal/with/object/factory", new Object[0])).then()).log().body()).statusCode(200)).body("person.firstName", Matchers.is((Object)PERSON_FIRST_NAME), new Object[]{"person.lastName", Matchers.is((Object)PERSON_LAST_NAME), "person.age", Matchers.is((Object)String.valueOf(25))});
    }

    @Test
    public void marshalWithoutObjectFactory() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("firstName", new Object[]{PERSON_FIRST_NAME}).queryParam("lastName", new Object[]{PERSON_LAST_NAME}).queryParam("age", new Object[]{25}).get("/jaxb/marshal/without/object/factory", new Object[0])).then()).statusCode(200)).body("firstName", Matchers.is((Object)PERSON_FIRST_NAME), new Object[]{"lastName", Matchers.is((Object)PERSON_LAST_NAME), "age", Matchers.is((Object)25)});
    }

    @Test
    public void marshalWithNoNamespaceSchemaLocation() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("firstName", new Object[]{PERSON_FIRST_NAME}).queryParam("lastName", new Object[]{PERSON_LAST_NAME}).queryParam("age", new Object[]{25}).get("/jaxb/marshal/non/namespace/schema/location", new Object[0])).then()).statusCode(200)).body(Matchers.containsString((String)"noNamespaceSchemaLocation=\"person-no-namespace.xsd\""), new Matcher[0]);
    }

    private static String getPersonXml(Person person) {
        return JaxbTest.getPersonXml(person, "UTF-8");
    }

    private static String getPersonXml(Person person, String encoding) {
        try {
            StringWriter writer = new StringWriter();
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{person.getClass()});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)encoding);
            marshaller.marshal((Object)person, (Writer)writer);
            return writer.toString();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }
}

