/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.jaxb.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
class JaxbTest {
    JaxbTest() {
    }

    @Test
    public void testUnmarshalLastName() {
        String response = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.XML).body(JaxbTest.getPersonXml("Foo", "Bar", 22)).post("/jaxb/unmarshal-lastname", new Object[0])).then()).statusCode(201)).extract().asString();
        Assertions.assertThat((String)response).isEqualTo("Bar");
    }

    @Test
    public void testUnmarshalFirstName() {
        String response = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.XML).body(JaxbTest.getPersonXml("Foo", "Bar", 22)).post("/jaxb/unmarshal-firstname", new Object[0])).then()).statusCode(201)).extract().asString();
        Assertions.assertThat((String)response).isEqualTo("Foo");
    }

    @Test
    public void testMarshallFirstName() {
        String name = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("Foo").post("/jaxb/marshal-firstname", new Object[0])).then()).statusCode(201)).extract().asString();
        Assertions.assertThat((String)name).contains(new CharSequence[]{"<ns2:firstName>Foo</ns2:firstName>"});
    }

    @Test
    public void testMarshallLasttName() {
        String name = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("Bar").post("/jaxb/marshal-lastname", new Object[0])).then()).statusCode(201)).extract().asString();
        Assertions.assertThat((String)name).contains(new CharSequence[]{"<test:lastName>Bar</test:lastName>"});
    }

    private static String getPersonXml(String name, String lastName, Integer age) {
        return String.format("<person xmlns:ns2=\"http://example.com/a\"><ns2:firstName>%s</ns2:firstName><ns2:lastName>%s</ns2:lastName><age>%d</age></person>", name, lastName, age);
    }
}

