/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.jaxb.it;

import java.net.URI;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.quarkus.component.jaxb.it.model.Person;
import org.jboss.logging.Logger;

@Path(value="/jaxb")
@ApplicationScoped
public class JaxbResource {
    private static final Logger LOG = Logger.getLogger(JaxbResource.class);
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/unmarshal-lastname")
    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"text/plain"})
    public Response unmarshalLastNameFromXml(String message) throws Exception {
        LOG.infof("Sending to jaxb: %s", (Object)message);
        Person response = (Person)this.producerTemplate.requestBody("direct:unmarshal", (Object)message, Person.class);
        LOG.infof("Got response from jaxb: %s", (Object)response);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)response.getLastName()).build();
    }

    @Path(value="/unmarshal-firstname")
    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"text/plain"})
    public Response unmarshalFirstNameFromXml(String message) throws Exception {
        LOG.infof("Sending to jaxb: %s", (Object)message);
        Person response = (Person)this.producerTemplate.requestBody("direct:unmarshal-2", (Object)message, Person.class);
        LOG.infof("Got response from jaxb: %s", (Object)response);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)response.getFirstName()).build();
    }

    @Path(value="/marshal-firstname")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"application/xml"})
    public Response marshallFirstName(String name) throws Exception {
        Person p = new Person();
        p.setFirstName(name);
        String response = (String)this.producerTemplate.requestBody("direct:marshal", (Object)p, String.class);
        LOG.infof("Got response from jaxb=>: %s", (Object)response);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)response).build();
    }

    @Path(value="/marshal-lastname")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"application/xml"})
    public Response marshallLastName(String name) throws Exception {
        Person p = new Person();
        p.setLastName(name);
        String response = (String)this.producerTemplate.requestBody("direct:marshal-2", (Object)p, String.class);
        LOG.infof("Got response from jaxb=>: %s", (Object)response);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)response).build();
    }
}

