/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.jasypt.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@QuarkusTest
class JasyptTest {
    JasyptTest() {
    }

    @ParameterizedTest
    @ValueSource(strings={"direct:decryptConfiguration", "direct:decryptConfigurationFromXml", "direct:decryptConfigurationFromYaml"})
    void decryptSimpleConfigPropertyPlaceholder(String endpointURI) {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("endpointURI", new Object[]{endpointURI}).get("/jasypt/decrypt/configuration/greeting.secret", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Hello World"), new Matcher[0]);
    }

    @Test
    void decryptSimpleConfigPropertyPlaceholderWithExpression() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("endpointURI", new Object[]{"direct:decryptConfiguration"}).get("/jasypt/decrypt/configuration/greeting.expression.secret", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Hello World From Expression"), new Matcher[0]);
    }

    @Test
    void decryptSimpleConfigPropertyPlaceholderWithExplicitConfigProvider() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("endpointURI", new Object[]{"direct:decryptConfiguration"}).get("/jasypt/decrypt/configuration/explicit.config.provider.secret", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Hello World"), new Matcher[0]);
    }

    @Test
    void decryptInjectedConfigProperty() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/jasypt/decrypt/injected/configuration/direct:secretPropertyInjection", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.is((Object)"Hello World"), new Matcher[0]);
    }

    @Test
    void decryptInjectedConfigPropertyWithExplicitConfigProvider() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/jasypt/decrypt/injected/configuration/direct:secretExplicitConfigProviderPropertyInjection", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.is((Object)"Hello World"), new Matcher[0]);
    }

    @Test
    void timerConfiguredWithEncryptedPropertiesFired() {
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("expectedMessageCount", new Object[]{2}).get("/jasypt/timer/mock/results", new Object[0])).then()).statusCode(204);
    }

    @Test
    void resolveInsecureProperty() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("endpointURI", new Object[]{"direct:decryptConfiguration"}).get("/jasypt/decrypt/configuration/insecure.property", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Hello World"), new Matcher[0]);
    }
}

