/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.jasypt.it;

import org.apache.camel.quarkus.component.jasypt.JasyptConfigurationCustomizer;
import org.apache.camel.quarkus.component.jasypt.it.AlgorithmUtils;
import org.jasypt.encryption.pbe.config.EnvironmentStringPBEConfig;
import org.jasypt.iv.IvGenerator;
import org.jasypt.iv.RandomIvGenerator;
import org.jasypt.salt.RandomSaltGenerator;
import org.jasypt.salt.SaltGenerator;

public class CustomJasyptConfigurationCustomizer
implements JasyptConfigurationCustomizer {
    public void customize(EnvironmentStringPBEConfig environmentStringPBEConfig) {
        String prngAlgorithm = AlgorithmUtils.getPRNGAlgorithm();
        environmentStringPBEConfig.setAlgorithm("PBEWithHmacSHA256AndAES_256");
        environmentStringPBEConfig.setIvGenerator((IvGenerator)new RandomIvGenerator(prngAlgorithm));
        environmentStringPBEConfig.setSaltGenerator((SaltGenerator)new RandomSaltGenerator(prngAlgorithm));
    }
}

