/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.jasypt.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
public class JasyptRoutes
extends RouteBuilder {
    @ConfigProperty(name="greeting.secret")
    String secretProperty;
    @ConfigProperty(name="explicit.config.provider.secret")
    String secretExplicitConfigProviderProperty;

    public void configure() throws Exception {
        ((RouteDefinition)this.from("direct:decryptConfiguration").process("decryptConfig")).log("Decrypted: ${body}");
        ((ProcessorDefinition)this.from("direct:secretPropertyInjection").setBody().constant((Object)this.secretProperty)).log("Decrypted: ${body}");
        ((ProcessorDefinition)this.from("direct:secretExplicitConfigProviderPropertyInjection").setBody().constant((Object)this.secretExplicitConfigProviderProperty)).log("Decrypted: ${body}");
        ((RouteDefinition)((ProcessorDefinition)((RouteDefinition)this.from("timer:tick?delay={{timer.delay.secret}}&repeatCount={{timer.repeatCount.secret}}").id("secret-timer")).autoStartup(false).setBody().simple("delay = ${properties:timer.delay.secret}, repeatCount = ${properties:timer.repeatCount.secret}")).log("${body}")).to("mock:timerResult");
    }

    @Singleton
    @Named(value="decryptConfig")
    Processor decryptConfigProcessor() {
        return new Processor(){

            public void process(Exchange exchange) throws Exception {
                Message message = exchange.getMessage();
                String configKey = (String)message.getHeader("config.key", String.class);
                exchange.getContext().getPropertiesComponent().resolveProperty(configKey).ifPresent(arg_0 -> ((Message)message).setBody(arg_0));
            }
        };
    }
}

