/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.ipfs.it;

import java.nio.file.Paths;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.camel.ProducerTemplate;

@Path(value="/ipfs")
public class IpfsResource {
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/add")
    @POST
    @Consumes(value={"text/plain"})
    public String addFile(String path) {
        return (String)this.producerTemplate.requestBody("ipfs:add", (Object)Paths.get(path, new String[0]), String.class);
    }

    @Path(value="/cat")
    @GET
    @Produces(value={"text/plain"})
    public String catFile(@QueryParam(value="hash") String hash) {
        return (String)this.producerTemplate.requestBody("ipfs:cat", (Object)hash, String.class);
    }

    @Path(value="/get")
    @GET
    @Produces(value={"text/plain"})
    public String getFilePath(@QueryParam(value="hash") String hash) throws Exception {
        return (String)this.producerTemplate.requestBody("ipfs:get?outdir=target", (Object)hash, String.class);
    }
}

