/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.influxdb.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Disposes;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.stream.Collectors;
import org.apache.camel.FluentProducerTemplate;
import org.apache.camel.quarkus.component.influxdb.it.Point;
import org.apache.camel.quarkus.component.influxdb.it.Points;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBFactory;
import org.influxdb.dto.BatchPoints;
import org.influxdb.dto.Pong;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;

@Path(value="/influxdb")
@ApplicationScoped
public class InfluxdbResource {
    public static final String DB_NAME = "myTestTimeSeries";
    public static final String INFLUXDB_CONNECTION_PROPERTY = "influxdb.connection.url";
    public static final String INFLUXDB_CONNECTION_NAME = "influxDbConnection";
    @Inject
    FluentProducerTemplate producerTemplate;
    @ConfigProperty(name="influxdb.connection.url")
    String connectionUrl;

    @Singleton
    @jakarta.enterprise.inject.Produces
    InfluxDB createInfluxDbConnection() {
        InfluxDB influxDbConnection = InfluxDBFactory.connect((String)this.connectionUrl);
        influxDbConnection.query(new Query("CREATE DATABASE myTestTimeSeries"));
        return influxDbConnection;
    }

    void disposeInfluxDbConnection(@Disposes InfluxDB influxDbConnection) {
        influxDbConnection.query(new Query("DROP DATABASE myTestTimeSeries", ""));
        influxDbConnection.close();
    }

    @Path(value="/ping")
    @GET
    @Produces(value={"text/plain"})
    public String ping() {
        return ((Pong)this.producerTemplate.toF("influxdb:%s?operation=ping", new Object[]{INFLUXDB_CONNECTION_NAME}).request(Pong.class)).getVersion();
    }

    @Path(value="/insert")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public boolean insert(Point point) {
        org.influxdb.dto.Point result = (org.influxdb.dto.Point)this.producerTemplate.toF("influxdb:%s?databaseName=%s&operation=insert&retentionPolicy=autogen", new Object[]{INFLUXDB_CONNECTION_NAME, DB_NAME}).withBody((Object)point.toPoint()).request(org.influxdb.dto.Point.class);
        return result != null;
    }

    @Path(value="/batch")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public int batch(Points points) {
        return ((BatchPoints)this.producerTemplate.toF("influxdb:%s?batch=true", new Object[]{INFLUXDB_CONNECTION_NAME}).withBody((Object)points.toBatchPoints()).request(BatchPoints.class)).getPoints().size();
    }

    @Path(value="/query")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String query(String query) throws Exception {
        QueryResult result = (QueryResult)this.producerTemplate.toF("influxdb:%s?databaseName=%s&operation=query&retentionPolicy=autogen", new Object[]{INFLUXDB_CONNECTION_NAME, DB_NAME}).withHeader("camelInfluxDB.query", (Object)query).request(QueryResult.class);
        return result.getResults().stream().filter(r -> r.getSeries() != null).flatMap(r -> r.getSeries().stream()).map(QueryResult.Series::getName).collect(Collectors.joining(", "));
    }
}

