/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.influxdb.it;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.HashMap;
import org.apache.camel.component.influxdb.converters.CamelInfluxDbConverters;
import org.apache.camel.quarkus.component.influxdb.it.InfluxdbTestResource;
import org.apache.camel.quarkus.component.influxdb.it.Point;
import org.apache.camel.quarkus.component.influxdb.it.Points;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;

@QuarkusTest
@QuarkusTestResource(value=InfluxdbTestResource.class)
@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
class InfluxdbTest {
    InfluxdbTest() {
    }

    @Test
    @Order(value=1)
    public void pingTest() {
        ((ValidatableResponse)((Response)RestAssured.given().get("/influxdb/ping", new Object[0])).then()).body(Matchers.is((Object)InfluxdbTestResource.INFLUXDB_VERSION), new Matcher[0]);
    }

    @Test
    @Order(value=2)
    public void insertTest() {
        Point point = (Point)InfluxdbTest.createBatchPoints().getPoints().get(0);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)point).post("/influxdb/insert", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"true"), new Matcher[0]);
    }

    @Test
    @Order(value=3)
    public void batchInsertTest() {
        Points points = InfluxdbTest.createBatchPoints();
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)points).post("/influxdb/batch", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"2"), new Matcher[0]);
    }

    @Test
    @Order(value=4)
    public void queryTest() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("select * from cpu").post("/influxdb/query", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"cpu"), new Matcher[0]);
    }

    @Test
    @Order(value=5)
    public void doesNotAddCamelHeaders() {
        HashMap<String, Object> pointInMapFormat = new HashMap<String, Object>();
        pointInMapFormat.put("camelInfluxDB.MeasurementName", "testCPU");
        pointInMapFormat.put("busy", 99.999999);
        org.influxdb.dto.Point p = CamelInfluxDbConverters.fromMapToPoint(pointInMapFormat);
        Assertions.assertNotNull((Object)p);
        String line = p.lineProtocol();
        Assertions.assertNotNull((Object)line);
        Assertions.assertFalse((boolean)line.contains("camelInfluxDB.MeasurementName"));
    }

    private static Points createBatchPoints() {
        Points points = new Points();
        points.setDatabase("myTestTimeSeries");
        Point point1 = new Point();
        point1.setMeasurement("disk");
        point1.setTime(Long.valueOf(System.currentTimeMillis()));
        point1.addField("idle", Long.valueOf(90L));
        point1.addField("user", Long.valueOf(9L));
        point1.addField("system", Long.valueOf(1L));
        Point point2 = new Point();
        point2.setMeasurement("cpu");
        point2.setTime(Long.valueOf(System.currentTimeMillis()));
        point2.addField("used", Long.valueOf(8L));
        point2.addField("free", Long.valueOf(1L));
        points.addPoint(point1);
        points.addPoint(point2);
        return points;
    }
}

