/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.influxdb.it;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.util.Map;
import org.apache.camel.util.CollectionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.TestcontainersConfiguration;

public class InfluxdbTestResource
implements QuarkusTestResourceLifecycleManager {
    public static final Logger LOGGER = LoggerFactory.getLogger(InfluxdbTestResource.class);
    public static final int INFLUXDB_PORT = 8086;
    public static final String INFLUXDB_VERSION = "1.7.10";
    public static final String INFLUXDB_IMAGE = "influxdb:1.7.10";
    private GenericContainer<?> container;

    public Map<String, String> start() {
        LOGGER.info(TestcontainersConfiguration.getInstance().toString());
        try {
            this.container = new GenericContainer(INFLUXDB_IMAGE).withExposedPorts(new Integer[]{8086}).waitingFor((WaitStrategy)Wait.forListeningPort());
            this.container.start();
            return CollectionHelper.mapOf((Object)"influxdb.connection.url", (Object)("http://" + String.format("%s:%s", this.container.getContainerIpAddress(), this.container.getMappedPort(8086))), (Object[])new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        try {
            if (this.container != null) {
                this.container.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

