/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.infinispan;

import jakarta.inject.Named;
import jakarta.ws.rs.Produces;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteConfiguration;
import org.apache.camel.quarkus.component.infinispan.common.InfinispanCommonRoutes;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.util.OS;

public class InfinispanRoutes
extends InfinispanCommonRoutes {
    @Produces
    @Named(value="additionalConfig")
    Map<String, String> additionalInfinispanConfig() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("infinispan.client.hotrod.marshaller", ProtoStreamMarshaller.class.getName());
        if (OS.getCurrentOs().equals((Object)OS.MAC_OS) || OS.getCurrentOs().equals((Object)OS.WINDOWS)) {
            config.put("infinispan.client.hotrod.client_intelligence", "BASIC");
        }
        config.put("infinispan.client.hotrod.cache.camel-infinispan.configuration", "<local-cache>\n    <encoding media-type=\"application/x-protostream\" />\n</local-cache>");
        return config;
    }

    protected Configuration getConfigurationBuilder() {
        Config config = ConfigProvider.getConfig();
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        String[] hostParts = ((String)config.getValue("camel.component.infinispan.hosts", String.class)).split(":");
        clientBuilder.addServer().host(hostParts[0]).port(Integer.parseInt(hostParts[1]));
        clientBuilder.security().authentication().username((String)config.getValue("camel.component.infinispan.username", String.class)).password((String)config.getValue("camel.component.infinispan.password", String.class)).serverName((String)config.getValue("camel.component.infinispan.security-server-name", String.class)).saslMechanism((String)config.getValue("camel.component.infinispan.sasl-mechanism", String.class)).realm((String)config.getValue("camel.component.infinispan.security-realm", String.class)).marshaller((Marshaller)new ProtoStreamMarshaller());
        return clientBuilder.build();
    }

    protected InfinispanRemoteConfiguration getConfiguration() {
        InfinispanRemoteConfiguration configuration = new InfinispanRemoteConfiguration();
        configuration.setCacheContainerConfiguration(this.getConfigurationBuilder());
        return configuration;
    }
}

