/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.infinispan;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonObject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.infinispan.InfinispanQueryBuilder;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteComponent;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.quarkus.component.infinispan.model.Person;
import org.apache.camel.util.CollectionHelper;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.ServerStatistics;

@Path(value="/infinispan")
@ApplicationScoped
public class InfinispanResources {
    public static final String CACHE_NAME_CAMEL = "camel";
    public static final String CACHE_NAME_QUARKUS = "quarkus";
    @Inject
    RemoteCacheManager cacheManager;
    @Inject
    ProducerTemplate template;
    @Inject
    CamelContext camelContext;

    @Path(value="/inspect")
    @GET
    @Produces(value={"application/json"})
    public JsonObject inspectCamelInfinispanClientConfiguration() {
        InfinispanRemoteComponent component = (InfinispanRemoteComponent)this.camelContext.getComponent("infinispan", InfinispanRemoteComponent.class);
        return Json.createObjectBuilder().add("hosts", component.getConfiguration().getHosts()).add("cache-manager", Objects.toString(component.getConfiguration().getCacheContainer(), "none")).build();
    }

    @Path(value="/aggregate")
    @POST
    @Consumes(value={"text/plain"})
    public void aggregate(@QueryParam(value="component") String component, String content) {
        String uri = component.equals("infinispan") ? "direct:camelAggregation" : "direct:quarkusAggregation";
        Map<String, Object> headers = this.getCommonHeaders(component);
        headers.put("CORRELATOR_HEADER", "CORRELATOR_HEADER");
        this.template.sendBodyAndHeaders(uri, (Object)content, headers);
    }

    @Path(value="/clear")
    @DELETE
    public void clear(@QueryParam(value="component") String component) {
        Map<String, Object> headers = this.getCommonHeaders(component);
        this.template.sendBodyAndHeaders("direct:clear", null, headers);
    }

    @Path(value="/clearAsync")
    @DELETE
    public void clearAsync(@QueryParam(value="component") String component) throws ExecutionException, InterruptedException, TimeoutException {
        Map<String, Object> headers = this.getCommonHeaders(component);
        CompletableFuture future = (CompletableFuture)this.template.requestBodyAndHeaders("direct:clearAsync", null, headers, CompletableFuture.class);
        future.get(5L, TimeUnit.SECONDS);
    }

    @Path(value="/compute")
    @POST
    public void compute(@QueryParam(value="component") String component) {
        Map<String, Object> headers = this.getCommonHeaders(component);
        this.template.sendBodyAndHeaders("direct:compute", null, headers);
    }

    @Path(value="/computeAsync")
    @POST
    public void computeAsync(@QueryParam(value="component") String component) throws ExecutionException, InterruptedException, TimeoutException {
        Map<String, Object> headers = this.getCommonHeaders(component);
        CompletableFuture future = (CompletableFuture)this.template.requestBodyAndHeaders("direct:computeAsync", null, headers, CompletableFuture.class);
        future.get(5L, TimeUnit.SECONDS);
    }

    @Path(value="/containsKey")
    @GET
    @Produces(value={"text/plain"})
    public Boolean containsKey(@QueryParam(value="component") String component) {
        Map<String, Object> headers = this.getCommonHeaders(component);
        return (Boolean)this.template.requestBodyAndHeaders("direct:containsKey", null, headers, Boolean.class);
    }

    @Path(value="/containsValue")
    @GET
    @Produces(value={"text/plain"})
    public Boolean containsValue(@QueryParam(value="component") String component, @QueryParam(value="value") String value) {
        Map<String, Object> headers = this.getCommonHeaders(component);
        return (Boolean)this.template.requestBodyAndHeaders("direct:containsValue", (Object)value, headers, Boolean.class);
    }

    @Path(value="/get")
    @GET
    @Produces(value={"text/plain"})
    public String get(@QueryParam(value="component") String component, @QueryParam(value="key") String key) {
        Map<String, Object> headers = this.getCommonHeaders(component);
        headers.put("CamelInfinispanKey", Objects.requireNonNullElse(key, "the-key"));
        return (String)this.template.requestBodyAndHeaders("direct:get", null, headers, String.class);
    }

    @Path(value="/getOrDefault")
    @GET
    @Produces(value={"text/plain"})
    public String getOrDefault(@QueryParam(value="component") String component) {
        Map<String, Object> headers = this.getCommonHeaders(component);
        return (String)this.template.requestBodyAndHeaders("direct:getOrDefault", null, headers, String.class);
    }

    @Path(value="/put")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String put(@QueryParam(value="component") String component, String content) {
        Map<String, Object> headers = this.getCommonHeaders(component);
        return (String)this.template.requestBodyAndHeaders("direct:put", (Object)content, headers, String.class);
    }

    @Path(value="/putAsync")
    @POST
    @Consumes(value={"text/plain"})
    public void putAsync(@QueryParam(value="component") String component, String content) throws ExecutionException, InterruptedException, TimeoutException {
        Map<String, Object> headers = this.getCommonHeaders(component);
        CompletableFuture future = (CompletableFuture)this.template.requestBodyAndHeaders("direct:putAsync", (Object)content, headers, CompletableFuture.class);
        future.get(5L, TimeUnit.SECONDS);
    }

    @Path(value="/putAll")
    @POST
    public void putAll(@QueryParam(value="component") String component) {
        Map body = CollectionHelper.mapOf((Object)"key-1", (Object)"value-1", (Object[])new Object[]{"key-2", "value-2"});
        Map<String, Object> headers = this.getCommonHeaders(component);
        this.template.sendBodyAndHeaders("direct:putAll", (Object)body, headers);
    }

    @Path(value="/putAllAsync")
    @POST
    public void putAllAsync(@QueryParam(value="component") String component) throws ExecutionException, InterruptedException, TimeoutException {
        Map body = CollectionHelper.mapOf((Object)"key-1", (Object)"value-1", (Object[])new Object[]{"key-2", "value-2"});
        Map<String, Object> headers = this.getCommonHeaders(component);
        CompletableFuture future = (CompletableFuture)this.template.requestBodyAndHeaders("direct:putAllAsync", (Object)body, headers, CompletableFuture.class);
        future.get(5L, TimeUnit.SECONDS);
    }

    @Path(value="/putIdempotent")
    @POST
    @Consumes(value={"text/plain"})
    public void putIdempotent(@QueryParam(value="component") String component, @QueryParam(value="messageId") String messageId, String content) {
        String uri = component.equals("infinispan") ? "direct:camelIdempotent" : "direct:quarkusIdempotent";
        Map<String, Object> headers = this.getCommonHeaders(component);
        headers.put("MessageId", messageId);
        this.template.sendBodyAndHeaders(uri, (Object)content, headers);
    }

    @Path(value="/putIfAbsent")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String putIfAbsent(@QueryParam(value="component") String component, String content) {
        Map<String, Object> headers = this.getCommonHeaders(component);
        return (String)this.template.requestBodyAndHeaders("direct:putIfAbsent", (Object)content, headers, String.class);
    }

    @Path(value="/putIfAbsentAsync")
    @POST
    @Consumes(value={"text/plain"})
    public void putIfAbsentAsync(@QueryParam(value="component") String component, String content) throws ExecutionException, InterruptedException, TimeoutException {
        Map<String, Object> headers = this.getCommonHeaders(component);
        CompletableFuture future = (CompletableFuture)this.template.requestBodyAndHeaders("direct:putIfAbsentAsync", (Object)content, headers, CompletableFuture.class);
        future.get(5L, TimeUnit.SECONDS);
    }

    @Path(value="/query")
    @GET
    @Produces(value={"text/plain"})
    public Response query(@QueryParam(value="component") String component) {
        Map<String, Object> headers = this.getCommonHeaders(component);
        String cacheName = (String)headers.get("cacheName");
        this.cacheManager.getCache(cacheName).put((Object)"person", (Object)new Person("Test", "Person"));
        String query = "FROM person.Person WHERE firstName = 'Test'";
        InfinispanQueryBuilder builder = InfinispanQueryBuilder.create((String)query);
        headers.put("CamelInfinispanQueryBuilder", builder);
        List result = (List)this.template.requestBodyAndHeaders("direct:query", null, headers, List.class);
        if (result.isEmpty()) {
            return Response.status((int)404).build();
        }
        return Response.ok().entity(result.get(0)).build();
    }

    @Path(value="/remove")
    @DELETE
    public void remove(@QueryParam(value="component") String component) {
        Map<String, Object> headers = this.getCommonHeaders(component);
        this.template.requestBodyAndHeaders("direct:remove", null, headers, String.class);
    }

    @Path(value="/removeAsync")
    @DELETE
    public void removeAsync(@QueryParam(value="component") String component) throws ExecutionException, InterruptedException, TimeoutException {
        Map<String, Object> headers = this.getCommonHeaders(component);
        CompletableFuture future = (CompletableFuture)this.template.requestBodyAndHeaders("direct:removeAsync", null, headers, CompletableFuture.class);
        future.get(5L, TimeUnit.SECONDS);
    }

    @Path(value="/replace")
    @PATCH
    @Consumes(value={"text/plain"})
    public void replace(@QueryParam(value="component") String component, String content) {
        Map<String, Object> headers = this.getCommonHeaders(component);
        this.template.sendBodyAndHeaders("direct:replace", (Object)content, headers);
    }

    @Path(value="/replaceAsync")
    @PATCH
    @Consumes(value={"text/plain"})
    public void replaceAsync(@QueryParam(value="component") String component, String content) throws ExecutionException, InterruptedException, TimeoutException {
        Map<String, Object> headers = this.getCommonHeaders(component);
        CompletableFuture future = (CompletableFuture)this.template.requestBodyAndHeaders("direct:replaceAsync", (Object)content, headers, CompletableFuture.class);
        future.get(5L, TimeUnit.SECONDS);
    }

    @Path(value="/size")
    @GET
    @Produces(value={"text/plain"})
    public Integer size(@QueryParam(value="component") String component) {
        Map<String, Object> headers = this.getCommonHeaders(component);
        return (Integer)this.template.requestBodyAndHeaders("direct:size", null, headers, Integer.class);
    }

    @Path(value="/stats")
    @GET
    @Produces(value={"text/plain"})
    public Integer stats(@QueryParam(value="component") String component) {
        Map<String, Object> headers = this.getCommonHeaders(component);
        ServerStatistics statistics = (ServerStatistics)this.template.requestBodyAndHeaders("direct:stats", null, headers, ServerStatistics.class);
        return statistics.getIntStatistic("currentNumberOfEntries");
    }

    @Path(value="/mock/aggregation/results")
    @GET
    public void assertMockEndpointAggregationResults(@QueryParam(value="uri") String uri) throws InterruptedException {
        MockEndpoint mockEndpoint = (MockEndpoint)this.camelContext.getEndpoint(uri, MockEndpoint.class);
        mockEndpoint.expectedMessageCount(2);
        mockEndpoint.expectedBodiesReceived(new Object[]{13, 54});
        try {
            mockEndpoint.assertIsSatisfied(5000L);
        }
        finally {
            mockEndpoint.reset();
        }
    }

    @Path(value="/mock/event/results")
    @GET
    public void assertMockEndpointEventResults(@QueryParam(value="uri") String uri) throws InterruptedException {
        MockEndpoint mockEndpoint = (MockEndpoint)this.camelContext.getEndpoint(uri, MockEndpoint.class);
        mockEndpoint.expectedMessageCount(1);
        ((MockValueBuilder)mockEndpoint.message(0).header("CamelInfinispanEventType")).isEqualTo((Object)"CLIENT_CACHE_ENTRY_CREATED");
        ((MockValueBuilder)mockEndpoint.message(0).header("CamelInfinispanCacheName")).isNotNull();
        ((MockValueBuilder)mockEndpoint.message(0).header("CamelInfinispanKey")).isEqualTo((Object)"test-key");
        try {
            mockEndpoint.assertIsSatisfied(5000L);
        }
        finally {
            mockEndpoint.reset();
        }
    }

    @Path(value="/mock/idempotent/results")
    @GET
    public void assertMockEndpointIdempotentResults(@QueryParam(value="uri") String uri) throws InterruptedException {
        MockEndpoint mockEndpoint = (MockEndpoint)this.camelContext.getEndpoint(uri, MockEndpoint.class);
        mockEndpoint.expectedMessageCount(1);
        try {
            mockEndpoint.assertIsSatisfied(5000L);
        }
        finally {
            mockEndpoint.reset();
        }
    }

    @POST
    @Path(value="consumer/{routeId}/{enabled}")
    public void manageRoute(@PathParam(value="routeId") String routeId, @PathParam(value="enabled") boolean enabled) throws Exception {
        if (enabled) {
            this.camelContext.getRouteController().startRoute(routeId);
        } else {
            this.camelContext.getRouteController().stopRoute(routeId);
        }
    }

    private Map<String, Object> getCommonHeaders(String componentName) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("component", componentName);
        if (componentName.equals("infinispan")) {
            headers.put("cacheName", CACHE_NAME_CAMEL);
        } else {
            headers.put("cacheName", CACHE_NAME_QUARKUS);
        }
        return headers;
    }
}

