/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.infinispan;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.DisabledOnNativeImage;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.UUID;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.camel.quarkus.component.infinispan.InfinispanServerTestResource;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

@QuarkusTest
@QuarkusTestResource(value=InfinispanServerTestResource.class)
public class InfinispanTest {
    @AfterEach
    public void afterEach() {
        for (String componentName : InfinispanTest.componentNames()) {
            ((ValidatableResponse)((Response)RestAssured.with().queryParam("component", new Object[]{componentName}).delete("/infinispan/clear", new Object[0])).then()).statusCode(204);
            ((ValidatableResponse)((Response)RestAssured.with().queryParam("component", new Object[]{componentName}).get("/infinispan/get", new Object[0])).then()).statusCode(204);
        }
    }

    @DisabledOnNativeImage(value="https://github.com/apache/camel-quarkus/issues/3657")
    @ParameterizedTest
    @MethodSource(value={"componentNames"})
    public void aggregate(String componentName) {
        Assumptions.assumeTrue((boolean)componentName.equals("infinispan"));
        Stream.of(1, 3, 4, 5, 6, 7, 20, 21).forEach(value -> ((ValidatableResponse)((Response)RestAssured.with().queryParam("component", new Object[]{componentName}).body(value).post("/infinispan/aggregate", new Object[0])).then()).statusCode(204));
        ((ValidatableResponse)((Response)RestAssured.with().queryParam("uri", new Object[]{"mock:aggregationResult"}).get("/infinispan/mock/aggregation/results", new Object[0])).then()).statusCode(204);
    }

    @ParameterizedTest
    @MethodSource(value={"componentNamesWithSynchronicity"})
    public void clear(String componentName, boolean isAsync) {
        ((ValidatableResponse)((Response)RestAssured.with().queryParam("component", new Object[]{componentName}).body("Hello " + componentName).post("/infinispan/put", new Object[0])).then()).statusCode(204);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().queryParam("component", new Object[]{componentName}).get("/infinispan/get", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)("Hello " + componentName)), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.with().queryParam("component", new Object[]{componentName}).delete(this.computePath("/infinispan/clear", isAsync), new Object[0])).then()).statusCode(204);
        ((ValidatableResponse)((Response)RestAssured.with().queryParam("component", new Object[]{componentName}).get("/infinispan/get", new Object[0])).then()).statusCode(204);
    }

    @ParameterizedTest
    @MethodSource(value={"componentNamesWithSynchronicity"})
    public void compute(String componentName, boolean isAsync) {
        ((ValidatableResponse)((Response)RestAssured.with().queryParam("component", new Object[]{componentName}).body("Initial value").post("/infinispan/put", new Object[0])).then()).statusCode(204);
        ((ValidatableResponse)((Response)RestAssured.with().queryParam("component", new Object[]{componentName}).post(this.computePath("/infinispan/compute", isAsync), new Object[0])).then()).statusCode(204);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().queryParam("component", new Object[]{componentName}).get("/infinispan/get", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Initial value-remapped"), new Matcher[0]);
    }

    @ParameterizedTest
    @MethodSource(value={"componentNames"})
    public void containsKey(String componentName) {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().queryParam("component", new Object[]{componentName}).get("/infinispan/containsKey", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"false"), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.with().queryParam("component", new Object[]{componentName}).body("Hello " + componentName).post("/infinispan/put", new Object[0])).then()).statusCode(204);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().queryParam("component", new Object[]{componentName}).get("/infinispan/containsKey", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"true"), new Matcher[0]);
    }

    @ParameterizedTest
    @MethodSource(value={"componentNames"})
    public void containsValue(String componentName) {
        String value = "test-value";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().queryParam("component", new Object[]{componentName}).queryParam("value", new Object[]{value}).get("/infinispan/containsValue", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"false"), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.with().queryParam("component", new Object[]{componentName}).body(value).post("/infinispan/put", new Object[0])).then()).statusCode(204);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().queryParam("component", new Object[]{componentName}).queryParam("value", new Object[]{value}).get("/infinispan/containsValue", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"true"), new Matcher[0]);
    }

    @ParameterizedTest
    @MethodSource(value={"componentNames"})
    public void customListener(String componentName) {
        ((ValidatableResponse)((Response)RestAssured.with().queryParam("component", new Object[]{componentName}).post("/infinispan/consumer/" + componentName + "-custom-listener/true", new Object[0])).then()).statusCode(204);
        try {
            ((ValidatableResponse)((Response)RestAssured.with().queryParam("component", new Object[]{componentName}).body("Hello " + componentName).post("/infinispan/put", new Object[0])).then()).statusCode(204);
            ((ValidatableResponse)((Response)RestAssured.with().queryParam("uri", new Object[]{"mock:resultCustomListener"}).get("/infinispan/mock/event/results", new Object[0])).then()).statusCode(204);
        }
        catch (Throwable throwable) {
            ((ValidatableResponse)((Response)RestAssured.with().queryParam("component", new Object[]{componentName}).post("/infinispan/consumer/" + componentName + "-custom-listener/false", new Object[0])).then()).statusCode(204);
            throw throwable;
        }
        ((ValidatableResponse)((Response)RestAssured.with().queryParam("component", new Object[]{componentName}).post("/infinispan/consumer/" + componentName + "-custom-listener/false", new Object[0])).then()).statusCode(204);
    }

    @ParameterizedTest
    @MethodSource(value={"componentNames"})
    public void events(String componentName) {
        ((ValidatableResponse)((Response)RestAssured.with().queryParam("component", new Object[]{componentName}).post("/infinispan/consumer/" + componentName + "-events/true", new Object[0])).then()).statusCode(204);
        try {
            ((ValidatableResponse)((Response)RestAssured.with().queryParam("component", new Object[]{componentName}).body("Hello " + componentName).post("/infinispan/put", new Object[0])).then()).statusCode(204);
            ((ValidatableResponse)((Response)RestAssured.with().queryParam("uri", new Object[]{"mock:resultCreated"}).get("/infinispan/mock/event/results", new Object[0])).then()).statusCode(204);
        }
        catch (Throwable throwable) {
            ((ValidatableResponse)((Response)RestAssured.with().queryParam("component", new Object[]{componentName}).post("/infinispan/consumer/" + componentName + "-events/false", new Object[0])).then()).statusCode(204);
            throw throwable;
        }
        ((ValidatableResponse)((Response)RestAssured.with().queryParam("component", new Object[]{componentName}).post("/infinispan/consumer/" + componentName + "-events/false", new Object[0])).then()).statusCode(204);
    }

    @ParameterizedTest
    @MethodSource(value={"componentNames"})
    public void getOrDefault(String componentName) {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().queryParam("component", new Object[]{componentName}).get("/infinispan/getOrDefault", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"default-value"), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.with().queryParam("component", new Object[]{componentName}).body("Hello " + componentName).post("/infinispan/put", new Object[0])).then()).statusCode(204);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().queryParam("component", new Object[]{componentName}).get("/infinispan/getOrDefault", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)("Hello " + componentName)), new Matcher[0]);
    }

    @ParameterizedTest
    @MethodSource(value={"componentNames"})
    public void idempotent(String componentName) {
        String messageId = UUID.randomUUID().toString();
        IntStream.of(1, 10).forEach(value -> ((ValidatableResponse)((Response)RestAssured.with().queryParam("component", new Object[]{componentName}).queryParam("messageId", new Object[]{messageId}).body("Message " + value).post("/infinispan/putIdempotent", new Object[0])).then()).statusCode(204));
        ((ValidatableResponse)((Response)RestAssured.with().queryParam("uri", new Object[]{"mock:resultIdempotent"}).get("/infinispan/mock/idempotent/results", new Object[0])).then()).statusCode(204);
    }

    @Test
    public void inspect() {
        ((ValidatableResponse)((Response)RestAssured.when().get("/infinispan/inspect", new Object[0])).then()).body("hosts", Matchers.is((Matcher)Matchers.notNullValue()), new Object[]{"cache-manager", Matchers.is((Object)"none")});
    }

    @ParameterizedTest
    @MethodSource(value={"componentNamesWithSynchronicity"})
    public void put(String componentName, boolean isAsync) {
        ((ValidatableResponse)((Response)RestAssured.with().queryParam("component", new Object[]{componentName}).body("Hello " + componentName).post(this.computePath("/infinispan/put", isAsync), new Object[0])).then()).statusCode(204);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().queryParam("component", new Object[]{componentName}).get("/infinispan/get", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)("Hello " + componentName)), new Matcher[0]);
    }

    @ParameterizedTest
    @MethodSource(value={"componentNamesWithSynchronicity"})
    public void putAll(String componentName, boolean isAsync) {
        ((ValidatableResponse)((Response)RestAssured.with().queryParam("component", new Object[]{componentName}).post(this.computePath("/infinispan/putAll", isAsync), new Object[0])).then()).statusCode(204);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().queryParam("component", new Object[]{componentName}).queryParam("key", new Object[]{"key-1"}).get("/infinispan/get", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"value-1"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().queryParam("component", new Object[]{componentName}).queryParam("key", new Object[]{"key-2"}).get("/infinispan/get", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"value-2"), new Matcher[0]);
    }

    @ParameterizedTest
    @MethodSource(value={"componentNamesWithSynchronicity"})
    public void putIfAbsent(String componentName, boolean isAsync) {
        ((ValidatableResponse)((Response)RestAssured.with().queryParam("component", new Object[]{componentName}).body("Hello " + componentName).post(this.computePath("/infinispan/putIfAbsent", isAsync), new Object[0])).then()).statusCode(204);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().queryParam("component", new Object[]{componentName}).get("/infinispan/get", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)("Hello " + componentName)), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.with().queryParam("component", new Object[]{componentName}).body("An alternative value").post(this.computePath("/infinispan/putIfAbsent", isAsync), new Object[0])).then()).statusCode(204);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().queryParam("component", new Object[]{componentName}).get("/infinispan/get", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)("Hello " + componentName)), new Matcher[0]);
    }

    @ParameterizedTest
    @MethodSource(value={"componentNames"})
    public void query(String componentName) {
        ((ValidatableResponse)((Response)RestAssured.with().queryParam("component", new Object[]{componentName}).get("/infinispan/query", new Object[0])).then()).statusCode(200);
    }

    @ParameterizedTest
    @MethodSource(value={"componentNamesWithSynchronicity"})
    public void remove(String componentName, boolean isAsync) {
        ((ValidatableResponse)((Response)RestAssured.with().queryParam("component", new Object[]{componentName}).body("Hello " + componentName).post(this.computePath("/infinispan/put", isAsync), new Object[0])).then()).statusCode(204);
        ((ValidatableResponse)((Response)RestAssured.with().queryParam("component", new Object[]{componentName}).delete(this.computePath("/infinispan/remove", isAsync), new Object[0])).then()).statusCode(204);
        ((ValidatableResponse)((Response)RestAssured.with().queryParam("component", new Object[]{componentName}).get("/infinispan/get", new Object[0])).then()).statusCode(204);
    }

    @ParameterizedTest
    @MethodSource(value={"componentNamesWithSynchronicity"})
    public void replace(String componentName, boolean isAsync) {
        ((ValidatableResponse)((Response)RestAssured.with().queryParam("component", new Object[]{componentName}).body("Hello " + componentName).post(this.computePath("/infinispan/put", isAsync), new Object[0])).then()).statusCode(204);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().queryParam("component", new Object[]{componentName}).get("/infinispan/get", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)("Hello " + componentName)), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.with().queryParam("component", new Object[]{componentName}).body("replaced cache value").patch(this.computePath("/infinispan/replace", isAsync), new Object[0])).then()).statusCode(204);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().queryParam("component", new Object[]{componentName}).get("/infinispan/get", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"replaced cache value"), new Matcher[0]);
    }

    @ParameterizedTest
    @MethodSource(value={"componentNames"})
    public void size(String componentName) {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().queryParam("component", new Object[]{componentName}).get("/infinispan/size", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"0"), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.with().queryParam("component", new Object[]{componentName}).body("Hello " + componentName).post("/infinispan/put", new Object[0])).then()).statusCode(204);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().queryParam("component", new Object[]{componentName}).get("/infinispan/size", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"1"), new Matcher[0]);
    }

    @ParameterizedTest
    @MethodSource(value={"componentNames"})
    public void stats(String componentName) {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().queryParam("component", new Object[]{componentName}).get("/infinispan/stats", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"0"), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.with().queryParam("component", new Object[]{componentName}).body("Hello " + componentName).post("/infinispan/put", new Object[0])).then()).statusCode(204);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().queryParam("component", new Object[]{componentName}).get("/infinispan/stats", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"1"), new Matcher[0]);
    }

    private String computePath(String path, boolean isAsync) {
        if (isAsync) {
            path = (String)path + "Async";
        }
        return path;
    }

    public static String[] componentNames() {
        return new String[]{"infinispan", "infinispan-quarkus"};
    }

    public static Stream<Arguments> componentNamesWithSynchronicity() {
        return Stream.of(Arguments.of((Object[])new Object[]{"infinispan", false}), Arguments.of((Object[])new Object[]{"infinispan-quarkus", false}), Arguments.of((Object[])new Object[]{"infinispan", true}), Arguments.of((Object[])new Object[]{"infinispan-quarkus", true}));
    }
}

