/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.infinispan;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.util.Map;
import org.apache.camel.util.CollectionHelper;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.TestcontainersConfiguration;

public class InfinispanServerTestResource
implements QuarkusTestResourceLifecycleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfinispanServerTestResource.class);
    private static final String CONTAINER_IMAGE = "infinispan/server:13.0";
    private static final int HOTROD_PORT = 11222;
    private static final String USER = "camel";
    private static final String PASS = "camel";
    private GenericContainer<?> container;

    public Map<String, String> start() {
        LOGGER.info(TestcontainersConfiguration.getInstance().toString());
        try {
            this.container = new GenericContainer(CONTAINER_IMAGE).withExposedPorts(new Integer[]{11222}).withEnv("USER", "camel").withEnv("PASS", "camel").waitingFor((WaitStrategy)Wait.forListeningPort());
            this.container.start();
            String serverList = String.format("%s:%s", this.container.getContainerIpAddress(), this.container.getMappedPort(11222));
            Map result = CollectionHelper.mapOf((Object)"quarkus.infinispan-client.server-list", (Object)serverList, (Object[])new Object[]{"quarkus.infinispan-client.near-cache-max-entries", "3", "quarkus.infinispan-client.auth-username", "camel", "quarkus.infinispan-client.auth-password", "camel", "quarkus.infinispan-client.auth-realm", "default", "quarkus.infinispan-client.sasl-mechanism", "DIGEST-MD5", "quarkus.infinispan-client.auth-server-name", "infinispan", "camel.component.infinispan.autowired-enabled", "false", "camel.component.infinispan.hosts", serverList, "camel.component.infinispan.username", "camel", "camel.component.infinispan.password", "camel", "camel.component.infinispan.secure", "true", "camel.component.infinispan.security-realm", "default", "camel.component.infinispan.sasl-mechanism", "DIGEST-MD5", "camel.component.infinispan.security-server-name", "infinispan"});
            if (SystemUtils.IS_OS_MAC || SystemUtils.IS_OS_WINDOWS) {
                result.put("quarkus.infinispan-client.client-intelligence", "BASIC");
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        try {
            if (this.container != null) {
                this.container.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

