/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.infinispan;

import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.function.BiFunction;
import javax.inject.Named;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.infinispan.InfinispanOperation;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteAggregationRepository;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteComponent;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteComponentConfigurer;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteConfiguration;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteCustomListener;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteIdempotentRepository;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.AggregationRepository;
import org.apache.camel.spi.IdempotentRepository;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryCreated;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.event.ClientCacheEntryCreatedEvent;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.StringMarshaller;

public class InfinispanRoutes
extends RouteBuilder {
    public static final int COMPLETION_SIZE = 4;
    public static final String CORRELATOR_HEADER = "CORRELATOR_HEADER";

    public void configure() {
        ((ProcessorDefinition)((ProcessorDefinition)this.from("direct:clear").setHeader("CamelInfinispanOperation").constant((Object)InfinispanOperation.CLEAR)).setHeader("CamelInfinispanKey").constant((Object)"the-key")).toD("${header.component}:${header.cacheName}");
        ((ProcessorDefinition)((ProcessorDefinition)this.from("direct:clearAsync").setHeader("CamelInfinispanOperation").constant((Object)InfinispanOperation.CLEARASYNC)).setHeader("CamelInfinispanKey").constant((Object)"the-key")).toD("${header.component}:${header.cacheName}");
        ((ProcessorDefinition)((ProcessorDefinition)this.from("direct:compute").setHeader("CamelInfinispanOperation").constant((Object)InfinispanOperation.COMPUTE)).setHeader("CamelInfinispanKey").constant((Object)"the-key")).toD("${header.component}:${header.cacheName}?remappingFunction=#customMappingFunction");
        ((ProcessorDefinition)((ProcessorDefinition)this.from("direct:computeAsync").setHeader("CamelInfinispanOperation").constant((Object)InfinispanOperation.COMPUTEASYNC)).setHeader("CamelInfinispanKey").constant((Object)"the-key")).toD("${header.component}:${header.cacheName}?remappingFunction=#customMappingFunction");
        ((ProcessorDefinition)((ProcessorDefinition)this.from("direct:containsKey").setHeader("CamelInfinispanOperation").constant((Object)InfinispanOperation.CONTAINSKEY)).setHeader("CamelInfinispanKey").constant((Object)"the-key")).toD("${header.component}:${header.cacheName}");
        ((ProcessorDefinition)((ProcessorDefinition)this.from("direct:containsValue").setHeader("CamelInfinispanOperation").constant((Object)InfinispanOperation.CONTAINSVALUE)).setHeader("CamelInfinispanValue").body()).toD("${header.component}:${header.cacheName}");
        ((ProcessorDefinition)this.from("direct:get").setHeader("CamelInfinispanOperation").constant((Object)InfinispanOperation.GET)).toD("${header.component}:${header.cacheName}");
        ((ProcessorDefinition)((ProcessorDefinition)((ProcessorDefinition)this.from("direct:getOrDefault").setHeader("CamelInfinispanOperation").constant((Object)InfinispanOperation.GETORDEFAULT)).setHeader("CamelInfinispanKey").constant((Object)"the-key")).setHeader("CamelInfinispanDefaultValue").constant((Object)"default-value")).toD("${header.component}:${header.cacheName}");
        ((ProcessorDefinition)((ProcessorDefinition)((ProcessorDefinition)this.from("direct:put").setHeader("CamelInfinispanOperation").constant((Object)InfinispanOperation.PUT)).setHeader("CamelInfinispanKey").constant((Object)"the-key")).setHeader("CamelInfinispanValue").body()).toD("${header.component}:${header.cacheName}");
        ((ProcessorDefinition)((ProcessorDefinition)((ProcessorDefinition)this.from("direct:putAsync").setHeader("CamelInfinispanOperation").constant((Object)InfinispanOperation.PUTASYNC)).setHeader("CamelInfinispanKey").constant((Object)"the-key")).setHeader("CamelInfinispanValue").body()).toD("${header.component}:${header.cacheName}");
        ((ProcessorDefinition)((ProcessorDefinition)this.from("direct:putAll").setHeader("CamelInfinispanOperation").constant((Object)InfinispanOperation.PUTALL)).setHeader("CamelInfinispanMap").body()).toD("${header.component}:${header.cacheName}");
        ((ProcessorDefinition)((ProcessorDefinition)this.from("direct:putAllAsync").setHeader("CamelInfinispanOperation").constant((Object)InfinispanOperation.PUTALLASYNC)).setHeader("CamelInfinispanMap").body()).toD("${header.component}:${header.cacheName}");
        ((ProcessorDefinition)((ProcessorDefinition)((ProcessorDefinition)this.from("direct:putIfAbsent").setHeader("CamelInfinispanOperation").constant((Object)InfinispanOperation.PUTIFABSENT)).setHeader("CamelInfinispanKey").constant((Object)"the-key")).setHeader("CamelInfinispanValue").body()).toD("${header.component}:${header.cacheName}");
        ((ProcessorDefinition)((ProcessorDefinition)((ProcessorDefinition)this.from("direct:putIfAbsentAsync").setHeader("CamelInfinispanOperation").constant((Object)InfinispanOperation.PUTIFABSENTASYNC)).setHeader("CamelInfinispanKey").constant((Object)"the-key")).setHeader("CamelInfinispanValue").body()).toD("${header.component}:${header.cacheName}");
        ((ProcessorDefinition)this.from("direct:query").setHeader("CamelInfinispanOperation").constant((Object)InfinispanOperation.QUERY)).toD("${header.component}:${header.cacheName}");
        ((ProcessorDefinition)((ProcessorDefinition)this.from("direct:remove").setHeader("CamelInfinispanOperation").constant((Object)InfinispanOperation.REMOVE)).setHeader("CamelInfinispanKey").constant((Object)"the-key")).toD("${header.component}:${header.cacheName}");
        ((ProcessorDefinition)((ProcessorDefinition)this.from("direct:removeAsync").setHeader("CamelInfinispanOperation").constant((Object)InfinispanOperation.REMOVEASYNC)).setHeader("CamelInfinispanKey").constant((Object)"the-key")).toD("${header.component}:${header.cacheName}");
        ((ProcessorDefinition)((ProcessorDefinition)((ProcessorDefinition)this.from("direct:replace").setHeader("CamelInfinispanOperation").constant((Object)InfinispanOperation.REPLACE)).setHeader("CamelInfinispanKey").constant((Object)"the-key")).setHeader("CamelInfinispanValue").body()).toD("${header.component}:${header.cacheName}");
        ((ProcessorDefinition)((ProcessorDefinition)((ProcessorDefinition)this.from("direct:replaceAsync").setHeader("CamelInfinispanOperation").constant((Object)InfinispanOperation.REPLACEASYNC)).setHeader("CamelInfinispanKey").constant((Object)"the-key")).setHeader("CamelInfinispanValue").body()).toD("${header.component}:${header.cacheName}");
        ((ProcessorDefinition)((ProcessorDefinition)this.from("direct:size").setHeader("CamelInfinispanOperation").constant((Object)InfinispanOperation.SIZE)).setHeader("CamelInfinispanKey").constant((Object)"the-key")).toD("${header.component}:${header.cacheName}");
        ((ProcessorDefinition)this.from("direct:stats").setHeader("CamelInfinispanOperation").constant((Object)InfinispanOperation.STATS)).toD("${header.component}:${header.cacheName}");
        ((RouteDefinition)this.from("infinispan:camel?eventTypes=CLIENT_CACHE_ENTRY_CREATED").id("infinispan-events")).autoStartup(false).to("mock:camelResultCreated");
        this.from("direct:camelAggregation").aggregate((Expression)this.header(CORRELATOR_HEADER)).aggregationRepository((AggregationRepository)this.createAggregationRepository("infinispan")).aggregationStrategy(this.createAggregationStrategy()).completionSize(4).to("mock:camelAggregationResult");
        this.from("direct:quarkusAggregation").aggregate((Expression)this.header(CORRELATOR_HEADER)).aggregationRepository((AggregationRepository)this.createAggregationRepository("infinispan-quarkus")).aggregationStrategy(this.createAggregationStrategy()).completionSize(4).to("mock:quarkusAggregationResult");
        this.from("direct:camelIdempotent").idempotentConsumer((Expression)this.header("MessageID"), (IdempotentRepository)this.createIdempotentRepository("infinispan")).to("mock:camelResultIdempotent");
        this.from("direct:quarkusIdempotent").idempotentConsumer((Expression)this.header("MessageID"), (IdempotentRepository)this.createIdempotentRepository("infinispan-quarkus")).to("mock:quarkusResultIdempotent");
        ((RouteDefinition)this.from("infinispan-quarkus:quarkus?eventTypes=CLIENT_CACHE_ENTRY_CREATED").id("infinispan-quarkus-events")).autoStartup(false).to("mock:quarkusResultCreated");
        ((RouteDefinition)this.from("infinispan:camel?customListener=#customListener").id("infinispan-custom-listener")).autoStartup(false).to("mock:camelResultCustomListener");
        ((RouteDefinition)this.from("infinispan-quarkus:quarkus?customListener=#customListener").id("infinispan-quarkus-custom-listener")).autoStartup(false).to("mock:quarkusResultCustomListener");
    }

    @Named(value="infinispan-quarkus")
    public InfinispanRemoteComponent infinispanQuarkus() {
        return new InfinispanRemoteComponent();
    }

    @Named(value="infinispan-quarkus-component")
    public InfinispanRemoteComponentConfigurer quarkusInfinispanConfigurer() {
        return new InfinispanRemoteComponentConfigurer();
    }

    @Named(value="customMappingFunction")
    public BiFunction<String, String, String> mappingFunction() {
        return (k, v) -> v + "-remapped";
    }

    @Named(value="customListener")
    public InfinispanRemoteCustomListener customListener() {
        return new CustomListener();
    }

    private InfinispanRemoteIdempotentRepository createIdempotentRepository(String componentName) {
        String cacheName = componentName.equals("infinispan") ? "camel" : "quarkus";
        InfinispanRemoteConfiguration configuration = this.getConfiguration(componentName);
        InfinispanRemoteIdempotentRepository repository = new InfinispanRemoteIdempotentRepository(cacheName);
        repository.setConfiguration(configuration);
        return repository;
    }

    private InfinispanRemoteAggregationRepository createAggregationRepository(String componentName) {
        String cacheName = componentName.equals("infinispan") ? "camel" : "quarkus";
        InfinispanRemoteAggregationRepository aggregationRepository = new InfinispanRemoteAggregationRepository(cacheName);
        InfinispanRemoteConfiguration configuration = this.getConfiguration(componentName);
        aggregationRepository.setConfiguration(configuration);
        return aggregationRepository;
    }

    private InfinispanRemoteConfiguration getConfiguration(String componentName) {
        CamelContext camelContext = this.getCamelContext();
        InfinispanRemoteComponent component = (InfinispanRemoteComponent)camelContext.getComponent(componentName, InfinispanRemoteComponent.class);
        InfinispanRemoteConfiguration configuration = component.getConfiguration().clone();
        configuration.setCacheContainerConfiguration(this.getConfigurationBuilder());
        Set beans = camelContext.getRegistry().findByType(RemoteCacheManager.class);
        RemoteCacheManager cacheManager = (RemoteCacheManager)beans.iterator().next();
        configuration.setCacheContainer(cacheManager);
        return configuration;
    }

    private Configuration getConfigurationBuilder() {
        Config config = ConfigProvider.getConfig();
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        String[] hostParts = ((String)config.getValue("quarkus.infinispan-client.server-list", String.class)).split(":");
        clientBuilder.addServer().host(hostParts[0]).port(Integer.parseInt(hostParts[1]));
        clientBuilder.security().authentication().username((String)config.getValue("quarkus.infinispan-client.auth-username", String.class)).password((String)config.getValue("quarkus.infinispan-client.auth-password", String.class)).serverName((String)config.getValue("quarkus.infinispan-client.auth-server-name", String.class)).saslMechanism((String)config.getValue("quarkus.infinispan-client.sasl-mechanism", String.class)).realm((String)config.getValue("quarkus.infinispan-client.auth-realm", String.class)).marshaller((Marshaller)new StringMarshaller(StandardCharsets.UTF_8));
        return clientBuilder.build();
    }

    private AggregationStrategy createAggregationStrategy() {
        return (oldExchange, newExchange) -> {
            if (oldExchange == null) {
                return newExchange;
            }
            Integer n = (Integer)newExchange.getIn().getBody(Integer.class);
            Integer o = (Integer)oldExchange.getIn().getBody(Integer.class);
            Integer v = (o == null ? 0 : o) + (n == null ? 0 : n);
            oldExchange.getIn().setBody((Object)v, Integer.class);
            return oldExchange;
        };
    }

    @ClientListener
    static final class CustomListener
    extends InfinispanRemoteCustomListener {
        CustomListener() {
        }

        @ClientCacheEntryCreated
        public void entryCreated(ClientCacheEntryCreatedEvent<?> event) {
            if (this.isAccepted(event.getType())) {
                this.getEventProcessor().processEvent(event.getType().toString(), this.getCacheName(), event.getKey(), null, null);
            }
        }
    }
}

