/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.infinispan;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonObject;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteComponent;
import org.infinispan.client.hotrod.RemoteCacheManager;

@Path(value="/test")
@ApplicationScoped
public class InfinispanResources {
    public static final String CACHE_NAME = "camel";
    @Inject
    RemoteCacheManager cacheManager;
    @Inject
    ProducerTemplate template;
    @Inject
    CamelContext camelContext;

    @PostConstruct
    public void setUp() {
        this.cacheManager.administration().getOrCreateCache(CACHE_NAME, (String)null);
    }

    @Path(value="/inspect")
    @GET
    @Produces(value={"application/json"})
    public JsonObject inspectCamelInfinispanClientConfiguration() {
        InfinispanRemoteComponent component = (InfinispanRemoteComponent)this.camelContext.getComponent("infinispan", InfinispanRemoteComponent.class);
        return Json.createObjectBuilder().add("hosts", component.getConfiguration().getHosts()).add("cache-manager", Objects.toString(component.getConfiguration().getCacheContainer(), "none")).build();
    }

    @Path(value="/get")
    @GET
    @Produces(value={"text/plain"})
    public String get(@QueryParam(value="component") String component) {
        Map<String, Object> headers = this.getCommonHeaders(component);
        return (String)this.template.requestBodyAndHeaders("direct:get", (Object)"", headers, String.class);
    }

    @Path(value="/put")
    @POST
    @Produces(value={"text/plain"})
    public String put(@QueryParam(value="component") String component, String content) {
        Map<String, Object> headers = this.getCommonHeaders(component);
        return (String)this.template.requestBodyAndHeaders("direct:put", (Object)content, headers, String.class);
    }

    private Map<String, Object> getCommonHeaders(String componentName) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("component", componentName);
        headers.put("cacheName", CACHE_NAME);
        return headers;
    }
}

