/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.infinispan;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.apache.camel.quarkus.component.infinispan.InfinispanServerTestResource;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@QuarkusTest
@QuarkusTestResource(value=InfinispanServerTestResource.class)
public class InfinispanTest {
    @Test
    public void inspect() {
        ((ValidatableResponse)((Response)RestAssured.when().get("/test/inspect", new Object[0])).then()).body("hosts", Matchers.is((Matcher)Matchers.notNullValue()), new Object[]{"cache-manager", Matchers.is((Object)"none")});
    }

    @ParameterizedTest
    @ValueSource(strings={"infinispan", "infinispan-quarkus"})
    public void testInfinispan(String componentName) {
        ((ValidatableResponse)((Response)RestAssured.with().queryParam("component", new Object[]{componentName}).body("Hello " + componentName).post("/test/put", new Object[0])).then()).statusCode(204);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().queryParam("component", new Object[]{componentName}).get("/test/get", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)("Hello " + componentName)), new Matcher[0]);
    }
}

