/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.infinispan;

import java.util.Map;
import org.apache.camel.quarkus.testcontainers.ContainerResourceLifecycleManager;
import org.apache.camel.quarkus.testcontainers.ContainerSupport;
import org.apache.camel.util.CollectionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.TestcontainersConfiguration;

public class InfinispanServerTestResource
implements ContainerResourceLifecycleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfinispanServerTestResource.class);
    private static final String CONTAINER_IMAGE = "docker.io/infinispan/server:10.1.5.Final";
    private static final int HOTROD_PORT = 11222;
    private static final String USER = "camel";
    private static final String PASS = "camel";
    private GenericContainer<?> container;

    public Map<String, String> start() {
        LOGGER.info(TestcontainersConfiguration.getInstance().toString());
        try {
            this.container = new GenericContainer(CONTAINER_IMAGE).withExposedPorts(new Integer[]{11222}).withEnv("USER", "camel").withEnv("PASS", "camel").waitingFor((WaitStrategy)Wait.forListeningPort());
            this.container.start();
            return CollectionHelper.mapOf((Object)"quarkus.infinispan-client.server-list", (Object)ContainerSupport.getHostAndPort(this.container, (int)11222), (Object[])new Object[]{"quarkus.infinispan-client.near-cache-max-entries", "3", "quarkus.infinispan-client.auth-username", "camel", "quarkus.infinispan-client.auth-password", "camel", "quarkus.infinispan-client.auth-realm", "default", "quarkus.infinispan-client.sasl-mechanism", "DIGEST-MD5", "quarkus.infinispan-client.auth-server-name", "infinispan"});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        try {
            if (this.container != null) {
                this.container.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

