/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.http.vertx.it;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.apache.camel.quarkus.component.http.common.AbstractHttpTest;
import org.apache.camel.quarkus.component.http.common.HttpTestResource;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
@QuarkusTestResource(value=HttpTestResource.class)
public class VertxHttpTest
extends AbstractHttpTest {
    @Override
    public String component() {
        return "vertx-http";
    }

    @Test
    public void vertxHttpMultipartFormParamsShouldSucceed() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("test-port", new Object[]{RestAssured.port}).queryParam("organization", new Object[]{"Apache"}).queryParam("project", new Object[]{"Camel"}).when().get("/test/client/{component}/multipart-form-params", new Object[]{this.component()})).then()).statusCode(200)).body(Matchers.is((Object)"multipartFormParams(Apache, Camel)"), new Matcher[0]);
    }

    @Test
    public void vertxHttpMultipartFormDataShouldSucceed() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("test-port", new Object[]{RestAssured.port}).when().get("/test/client/vertx-http/multipart-form-data", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"multipartFormData(part1=content1, <part2 value=\"content2\"/>)"), new Matcher[0]);
    }

    @Test
    public void vertxHttpCustomVertxOptionsShouldSucceed() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("test-port", new Object[]{RestAssured.port}).when().get("/test/client/vertx-http/custom-vertx-options", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"OK: the custom vertxOptions has triggered the expected exception"), new Matcher[0]);
    }

    @Test
    public void vertxHttpSessionManagementShouldReturnSecretContent() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("test-port", new Object[]{RestAssured.port}).when().get("/test/client/vertx-http/session-management", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Some secret content"), new Matcher[0]);
    }

    @Test
    public void vertxHttpBufferConversionWithCharset() {
        byte[] actualBytes = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("string", new Object[]{"special char \u20ac"}).queryParam("charset", new Object[]{"iso-8859-15"}).when().get("/test/client/vertx-http/buffer-conversion-with-charset", new Object[0])).then()).statusCode(200)).extract().asByteArray();
        byte[] expectedBytes = new byte[]{115, 112, 101, 99, 105, 97, 108, 32, 99, 104, 97, 114, 32, -92};
        Assertions.assertArrayEquals((byte[])expectedBytes, (byte[])actualBytes);
    }

    @Override
    @Test
    public void compression() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/test/client/{component}/compression", new Object[]{this.component()})).then()).statusCode(200)).body(Matchers.is((Object)"Compressed response"), new Matcher[0]);
    }
}

