/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.http.netty.it;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.List;
import org.apache.camel.quarkus.component.http.common.AbstractHttpTest;
import org.apache.camel.quarkus.component.http.common.HttpTestResource;
import org.apache.camel.quarkus.component.http.netty.it.NettyHttpTestResource;
import org.assertj.core.api.Assertions;
import org.eclipse.microprofile.config.ConfigProvider;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.ValueSource;

@QuarkusTest
@QuarkusTestResource.List(value={@QuarkusTestResource(value=HttpTestResource.class), @QuarkusTestResource(value=NettyHttpTestResource.class)})
public class NettyHttpTest
extends AbstractHttpTest {
    @Override
    public String component() {
        return "netty-http";
    }

    @Test
    public void basicNettyHttpServer() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(((Integer)ConfigProvider.getConfig().getValue("camel.netty-http.test-port", Integer.class)).intValue()).when().get("/test/server/hello", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Netty Hello World"), new Matcher[0]);
    }

    @Test
    public void transferException() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("test-port", new Object[]{this.getPort("camel.netty-http.test-port")}).when().get("/test/client/{component}/serialized/exception", new Object[]{this.component()})).then()).statusCode(200)).body(Matchers.is((Object)"java.lang.IllegalStateException"), new Matcher[0]);
    }

    @Override
    @Test
    public void compression() {
        int port = this.getPort("camel.netty-http.compression-test-port");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("test-port", new Object[]{port}).when().get("/test/client/{component}/compression", new Object[]{this.component()})).then()).statusCode(200)).body(Matchers.is((Object)"Netty Hello World Compressed"), new Matcher[0]);
    }

    @Test
    public void testExtractHttpRequestFromNettyHttpMessage() {
        String method = "POST";
        String headerName = "testHeaderKey";
        String headerValue = "testHeaderValue";
        String body = "Test body";
        Response response = (Response)RestAssured.given().queryParam("test-port", new Object[]{this.getPort("camel.netty-http.port")}).when().get("/test/client/{component}/getRequest/{method}/{hName}/{hValue}/{body}", new Object[]{this.component(), "POST", "testHeaderKey", "testHeaderValue", "Test body"});
        Assertions.assertThat((int)response.getStatusCode()).isEqualTo(200);
        Assertions.assertThat((Object[])response.getBody().print().split(",")).containsAll(List.of("POST", "Test body", "testHeaderKey:testHeaderValue"));
    }

    @Test
    public void testExtractHttpResponseFromNettyHttpMessage() {
        String message = "httpResponseTest";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("test-port", new Object[]{this.getPort("camel.netty-http.port")}).when().get("/test/client/{component}/getResponse/{message}", new Object[]{this.component(), "httpResponseTest"})).then()).statusCode(200)).body(Matchers.is((Object)"Received message httpResponseTest: OK 200"), new Matcher[0]);
    }

    @ParameterizedTest
    @ValueSource(strings={"wildcard", "wildcard/example.txt"})
    public void testWildcardMatching(String path) {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("test-port", new Object[]{this.getPort("camel.netty-http.port")}).when().get("/test/client/{component}/wildcard/{path}", new Object[]{this.component(), path})).then()).statusCode(200)).body(Matchers.is((Object)"wildcard matched"), new Matcher[0]);
    }

    @Test
    public void testProxy() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("test-port", new Object[]{this.getPort("camel.netty-http.port")}).queryParam("proxy-port", new Object[]{this.getPort("camel.netty-http.proxyPort")}).when().get("/test/client/{component}/consumer-proxy", new Object[]{this.component()})).then()).statusCode(200)).body(Matchers.is((Object)"proxy"), new Matcher[0]);
    }

    @ParameterizedTest
    @CsvSource(value={"null,null,401", "admin,wrongpass,401", "admin,adminpass,200"})
    public void testCredentials(String user, String password, int responseCode) {
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("test-port", new Object[]{this.getPort("camel.netty-http.port")}).when().get("/test/client/{component}/auth/{path}/{user}/{password}", new Object[]{this.component(), "auth?securityConfiguration=#securityConfig", user, password})).then()).statusCode(responseCode);
    }

    @ParameterizedTest
    @CsvSource(value={"admin,admin,adminpass,200", "admin,guest,guestpass,401", "admin,null,null,401", "guest,admin,adminpass,200", "guest,guest,guestpass,200", "guest,null,null,401", "wildcard,admin,adminpass,200", "wildcard,guest,guestpass,200", "wildcard,null,null,401", "public,admin,adminpass,200", "public,guest,guestpass,200", "public,null,null,200"})
    public void testAcls(String endpoint, String user, String password, int responseCode) {
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("test-port", new Object[]{this.getPort("camel.netty-http.port")}).when().get("/test/client/{component}/auth/{path}/{user}/{password}", new Object[]{this.component(), "acls/" + endpoint + "?securityConfiguration=#acl" + endpoint, user, password})).then()).statusCode(responseCode);
    }

    @ParameterizedTest
    @ValueSource(strings={"GET", "POST", "PUT", "DELETE"})
    public void testRest(String method) {
        ValidatableResponse response = (ValidatableResponse)((Response)RestAssured.given().queryParam("rest-port", new Object[]{this.getPort("camel.netty-http.restPort")}).when().get("/test/client/{component}/rest/{method}", new Object[]{this.component(), method})).then();
        if ("DELETE".equals(method)) {
            response.statusCode(500);
        } else {
            ((ValidatableResponse)response.statusCode(200)).body(Matchers.is((Object)method), new Matcher[0]);
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"json", "xml"})
    public void pojoTest(String type) {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("rest-port", new Object[]{this.getPort("camel.netty-http.restPort")}).when().get("/test/client/{component}/rest/pojo/{type}", new Object[]{this.component(), type})).then()).statusCode(200)).body(Matchers.is((Object)"Received: John Doe"), new Matcher[0]);
    }
}

