/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.http.common;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetSocket;
import io.vertx.core.streams.Pump;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.quarkus.test.AvailablePortFinder;
import org.jboss.logging.Logger;

public class HttpTestResource
implements QuarkusTestResourceLifecycleManager {
    private static final Logger LOG = Logger.getLogger(HttpTestResource.class);
    private ProxyServer server;

    public Map<String, String> start() {
        Map options = AvailablePortFinder.reserveNetworkPorts(Objects::toString, (String[])new String[]{"proxy.port", "camel.netty-http.test-port", "camel.netty-http.https-test-port", "camel.netty-http.compression-test-port"});
        options.put("proxy.host", "localhost");
        this.server = new ProxyServer(Integer.parseInt((String)options.get("proxy.port")), "admin", "adm1n");
        this.server.start();
        return options;
    }

    public void stop() {
        AvailablePortFinder.releaseReservedPorts();
        if (this.server != null) {
            this.server.stop();
        }
    }

    static final class ProxyServer
    implements Handler<HttpServerRequest> {
        private final int port;
        private final String proxyUser;
        private final String proxyPassword;
        private final Vertx vertx;
        private final HttpServer proxyServer;

        ProxyServer(int port, String proxyUser, String proxyPassword) {
            this.port = port;
            this.proxyUser = proxyUser;
            this.proxyPassword = proxyPassword;
            this.vertx = Vertx.vertx((VertxOptions)new VertxOptions().setWorkerPoolSize(1).setEventLoopPoolSize(1));
            this.proxyServer = this.vertx.createHttpServer();
        }

        void start() {
            CountDownLatch startLatch = new CountDownLatch(1);
            this.proxyServer.requestHandler((Handler)this);
            this.proxyServer.listen(this.port).onComplete(result -> {
                LOG.infof("HTTP proxy server started on port %d", (Object)this.port);
                startLatch.countDown();
            });
            try {
                startLatch.await(1L, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        void stop() {
            if (this.proxyServer != null) {
                LOG.info((Object)"HTTP proxy server shutting down");
                this.proxyServer.close();
            }
            if (this.vertx != null) {
                this.vertx.close();
            }
        }

        public void handle(HttpServerRequest httpServerRequest) {
            String authorization = httpServerRequest.getHeader("Proxy-Authorization");
            HttpServerResponse response = httpServerRequest.response();
            if (httpServerRequest.method().equals((Object)HttpMethod.CONNECT) && authorization == null) {
                response.putHeader("Proxy-Authenticate", "Basic").setStatusCode(407).end();
                return;
            }
            String[] authParts = authorization.split(" ");
            String[] credentials = new String(Base64.getDecoder().decode(authParts[1])).split(":");
            if (credentials.length != 2) {
                response.setStatusCode(400).end();
            } else if (credentials[0].equals(this.proxyUser) && credentials[1].equals(this.proxyPassword)) {
                String host = httpServerRequest.getHeader("Host");
                String[] hostParts = host.split(":");
                NetClient netClient = this.vertx.createNetClient();
                netClient.connect(Integer.parseInt(hostParts[1]), hostParts[0], result -> {
                    if (result.succeeded()) {
                        NetSocket clientSocket = (NetSocket)result.result();
                        NetSocket serverSocket = (NetSocket)httpServerRequest.toNetSocket().result();
                        serverSocket.closeHandler(v -> clientSocket.close());
                        clientSocket.closeHandler(v -> serverSocket.close());
                        Pump.pump((ReadStream)serverSocket, (WriteStream)clientSocket).start();
                        Pump.pump((ReadStream)clientSocket, (WriteStream)serverSocket).start();
                    } else {
                        response.setStatusCode(403).end();
                    }
                });
            } else {
                response.setStatusCode(401).end();
            }
        }
    }
}

