/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.http.common;

import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.eclipse.microprofile.config.ConfigProvider;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public abstract class AbstractHttpTest {
    public abstract String component();

    public abstract void compression();

    @Test
    public void basicProducerGet() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("test-port", new Object[]{RestAssured.port}).when().get("/test/client/{component}/get", new Object[]{this.component()})).then()).statusCode(200)).body(Matchers.is((Object)"get"), new Matcher[0]);
    }

    @Test
    public void basicProducerPost() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("test-port", new Object[]{RestAssured.port}).body("message").when().post("/test/client/{component}/post", new Object[]{this.component()})).then()).statusCode(200)).body(Matchers.is((Object)"MESSAGE"), new Matcher[0]);
    }

    @Test
    public void httpsProducer() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("component", new Object[]{this.component()}).when().get("/test/client/{component}/get-https", new Object[]{this.component()})).then()).statusCode(200)).body(Matchers.is((Object)"HTTPS GET"), new Matcher[0]);
    }

    @Test
    public void basicAuth() {
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("test-port", new Object[]{RestAssured.port}).queryParam("component", new Object[]{this.component()}).when().get("/test/client/{component}/auth/basic", new Object[]{this.component()})).then()).statusCode(401);
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("test-port", new Object[]{RestAssured.port}).queryParam("component", new Object[]{this.component()}).queryParam("username", new Object[]{"noadmin"}).queryParam("password", new Object[]{"n0Adm1n"}).when().get("/test/client/{component}/auth/basic", new Object[]{this.component()})).then()).statusCode(403);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("test-port", new Object[]{RestAssured.port}).queryParam("component", new Object[]{this.component()}).queryParam("username", new Object[]{"admin"}).queryParam("password", new Object[]{"adm1n"}).when().get("/test/client/{component}/auth/basic", new Object[]{this.component()})).then()).statusCode(200)).body(Matchers.is((Object)("Component " + this.component() + " is using basic auth")), new Matcher[0]);
    }

    @Test
    public void proxyServer() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/test/client/{component}/proxy", new Object[]{this.component()})).then()).statusCode(200)).body("metadata.groupId", Matchers.is((Object)"org.apache.camel.quarkus"), new Object[]{"metadata.artifactId", Matchers.is((Object)("camel-quarkus-" + this.component()))});
    }

    protected Integer getPort(String configKey) {
        return (Integer)ConfigProvider.getConfig().getValue(configKey, Integer.class);
    }
}

