/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.http.vertx;

import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.multipart.MultipartForm;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.nio.charset.StandardCharsets;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.PropertyBindingException;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.http.base.HttpOperationFailedException;
import org.apache.camel.quarkus.component.http.common.AbstractHttpResource;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

@Path(value="/test/client/vertx-http")
@ApplicationScoped
public class VertxResource
extends AbstractHttpResource {
    @Override
    @Path(value="/get")
    @GET
    @Produces(value={"text/plain"})
    public String httpGet(@QueryParam(value="test-port") int port) {
        return (String)this.producerTemplate.toF("vertx-http:http://localhost:%d/service/common/get", new Object[]{port}).withHeader("CamelHttpMethod", (Object)"GET").request(String.class);
    }

    @Override
    @Path(value="/post")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String httpPost(@QueryParam(value="test-port") int port, String message) {
        return (String)this.producerTemplate.toF("vertx-http:http://localhost:%d/service/common/toUpper", new Object[]{port}).withBody((Object)message).withHeader("Content-Type", (Object)"text/plain").withHeader("CamelHttpMethod", (Object)"POST").request(String.class);
    }

    @Override
    @Path(value="/auth/basic")
    @GET
    @Produces(value={"text/plain"})
    public Response basicAuth(@QueryParam(value="test-port") int port, @QueryParam(value="username") String username, @QueryParam(value="password") String password) {
        Exchange result = this.producerTemplate.withHeader("CamelHttpQuery", (Object)"component=vertx-http").toF("vertx-http:http://localhost:%d/test/client/vertx-http/auth/basic/secured?throwExceptionOnFailure=false&basicAuthUsername=%s&basicAuthPassword=%s", new Object[]{port, username, password}).send();
        Integer status = (Integer)result.getMessage().getHeader("CamelHttpResponseCode", Integer.class);
        String body = (String)result.getMessage().getBody(String.class);
        return Response.status((int)status).entity((Object)body).build();
    }

    @Override
    @Path(value="/proxy")
    @GET
    @Produces(value={"application/xml"})
    public String httpProxy() {
        Config config = ConfigProvider.getConfig();
        String proxyHost = (String)config.getValue("tiny.proxy.host", String.class);
        Integer proxyPort = (Integer)config.getValue("tiny.proxy.port", Integer.class);
        return (String)this.producerTemplate.toF("vertx-http:%s?proxyHost=%s&proxyPort=%d&proxyType=HTTP&proxyUsername=%s&proxyPassword=%s", new Object[]{String.format("https://repo.maven.apache.org/maven2/org/apache/camel/quarkus/camel-quarkus-%s/maven-metadata.xml", "vertx-http"), proxyHost, proxyPort, "admin", "adm1n"}).request(String.class);
    }

    @Path(value="/compression")
    @GET
    @Produces(value={"text/plain"})
    public String compression() {
        return (String)this.producerTemplate.toF("vertx-http:http://localhost:%d/service/common/compress?useCompression=true", new Object[]{ConfigProvider.getConfig().getValue("quarkus.http.test-port", Integer.class)}).withHeader("CamelHttpMethod", (Object)"GET").withHeader("Accept-Encoding", (Object)"gzip, deflate").request(String.class);
    }

    @Path(value="/serialized/exception")
    @GET
    @Produces(value={"text/plain"})
    public String vertxHttpSerializedException(@QueryParam(value="test-port") int port) {
        Exchange exchange = this.producerTemplate.toF("vertx-http:http://localhost:%d/test/server/serialized/exception?transferException=true", new Object[]{port}).withHeader("CamelHttpMethod", (Object)"GET").send();
        return exchange.getException().getClass().getName();
    }

    @Path(value="/multipart-form-params")
    @GET
    @Produces(value={"text/plain"})
    public String vertxHttpMultipartFormParams(@QueryParam(value="test-port") int port, @QueryParam(value="organization") String organization, @QueryParam(value="project") String project) {
        return (String)this.producerTemplate.toF("vertx-http:http://localhost:%d/service/multipart-form-params", new Object[]{port}).withBody((Object)("organization=" + organization + "&project=" + project)).withHeader("Content-Type", (Object)"application/x-www-form-urlencoded").request(String.class);
    }

    @Path(value="/multipart-form-data")
    @GET
    @Produces(value={"text/plain"})
    public String vertxHttpMultipartFormData(@QueryParam(value="test-port") int port) {
        MultipartForm form = MultipartForm.create();
        form.binaryFileUpload("part-1", "test1.txt", Buffer.buffer((byte[])"part1=content1".getBytes(StandardCharsets.UTF_8)), "text/plain");
        form.binaryFileUpload("part-2", "test2.xml", Buffer.buffer((byte[])"<part2 value=\"content2\"/>".getBytes(StandardCharsets.UTF_8)), "text/xml");
        return (String)this.producerTemplate.toF("vertx-http:http://localhost:%d/service/multipart-form-data", new Object[]{port}).withBody((Object)form).request(String.class);
    }

    @Path(value="/custom-vertx-options")
    @GET
    @Produces(value={"text/plain"})
    public String vertxHttpCustomVertxOptions(@QueryParam(value="test-port") int port) {
        try {
            this.producerTemplate.toF("vertx-http:http://localhost:%d/service/custom-vertx-options?vertxOptions=#myVertxOptions", new Object[]{port}).request();
            return "NOT_EXPECTED: the custom vertxOptions should have triggered a ResolveEndpointFailedException";
        }
        catch (ResolveEndpointFailedException refex) {
            Throwable firstLevelExceptionCause = refex.getCause();
            if (firstLevelExceptionCause instanceof PropertyBindingException) {
                if (firstLevelExceptionCause.getCause() instanceof IllegalArgumentException) {
                    return "OK: the custom vertxOptions has triggered the expected exception";
                }
                return "NOT_EXPECTED: the 2nd level exception cause should be of type IllegalArgumentException";
            }
            return "NOT_EXPECTED: the 1st level exception cause should be of type PropertyBindingException";
        }
    }

    @Path(value="/session-management")
    @GET
    @Produces(value={"text/plain"})
    public String vertxHttpSessionManagement(@QueryParam(value="test-port") int port) {
        String vertxHttpBaseUri = "vertx-http:http://localhost:" + port + "/service/session-management";
        Exchange result = (Exchange)this.producerTemplate.toF("%s/secure?sessionManagement=true&cookieStore=#myVertxCookieStore", new Object[]{vertxHttpBaseUri}).request(Exchange.class);
        HttpOperationFailedException exception = (HttpOperationFailedException)result.getException(HttpOperationFailedException.class);
        if (exception.getStatusCode() != 403) {
            return "NOT_EXPECTED: The first request in the session is expected to return HTTP 403";
        }
        result = (Exchange)this.producerTemplate.toF("%s/login?sessionManagement=true&cookieStore=#myVertxCookieStore", new Object[]{vertxHttpBaseUri}).withHeader("username", (Object)"my-username").withHeader("password", (Object)"my-password").request(Exchange.class);
        Message msg = result.getMessage();
        if (msg == null) {
            return "NOT_EXPECTED: The second request in the session should return a message";
        }
        String setCookieHeader = (String)msg.getHeader("Set-Cookie", String.class);
        if (setCookieHeader == null || !setCookieHeader.contains("sessionId=my-session-id-123")) {
            return "NOT_EXPECTED: The message should have a Set-Cookie String header containing \"sessionId=my-session-id-123\"";
        }
        return (String)this.producerTemplate.toF("%s/secure?sessionManagement=true&cookieStore=#myVertxCookieStore", new Object[]{vertxHttpBaseUri}).request(String.class);
    }

    @Path(value="/buffer-conversion-with-charset")
    @GET
    public byte[] vertxBufferConversionWithCharset(@QueryParam(value="string") String string, @QueryParam(value="charset") String charset) {
        Buffer buffer = (Buffer)this.producerTemplate.to("direct:vertx-http-buffer-conversion-with-charset").withBody((Object)string).withHeader("Content-Type", (Object)("text/plain;charset=" + charset)).request(Buffer.class);
        return buffer.getBytes();
    }
}

