/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.http.vertx;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.CookieParam;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import java.util.Map;

@Path(value="/service")
@ApplicationScoped
public class VertxHttpService {
    @POST
    @Path(value="/multipart-form-params")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/plain"})
    public String multipartFormParams(@FormParam(value="organization") String organization, @FormParam(value="project") String project) {
        return String.format("multipartFormParams(%s, %s)", organization, project);
    }

    @POST
    @Path(value="/multipart-form-data")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/plain"})
    public String multipartFormData(Map<String, String> parts) {
        if (parts.size() != 2 || !parts.containsKey("part-1") || !parts.containsKey("part-2")) {
            throw new IllegalArgumentException("There should be exactly 2 parts named \"part-1\" and \"parts-2\" in the multipart upload");
        }
        return String.format("multipartFormData(%s, %s)", parts.get("part-1"), parts.get("part-2"));
    }

    @GET
    @Path(value="/custom-vertx-options")
    public void customVertxOptions() {
    }

    @GET
    @Path(value="/session-management/secure")
    @Produces(value={"text/plain"})
    public String getSecuredContent(@CookieParam(value="sessionId") String cookie) {
        if ("my-session-id-123".equals(cookie)) {
            return "Some secret content";
        }
        throw new ForbiddenException("A cookie with session id is needed to access the secured content");
    }

    @GET
    @Path(value="/session-management/login")
    @Produces(value={"text/plain"})
    public Response login(@HeaderParam(value="username") String username, @HeaderParam(value="password") String password) {
        if ("my-username".equals(username) && "my-password".equals(password)) {
            NewCookie cookie = ((NewCookie.AbstractNewCookieBuilder)new NewCookie.Builder("sessionId").value("my-session-id-123")).build();
            return Response.ok().cookie(new NewCookie[]{cookie}).build();
        }
        throw new ForbiddenException("Wrong username/password, no cookie will be created");
    }
}

