/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.http.netty.auth;

import java.security.Principal;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.apache.camel.component.netty.http.HttpPrincipal;
import org.apache.camel.component.netty.http.SecurityAuthenticator;
import org.apache.camel.quarkus.component.http.netty.auth.TestRolePrincipal;

public class TestAuthenticator
implements SecurityAuthenticator {
    private static final Map<String, String> AUTH = Map.of("admin", "adminpass", "guest", "guestpass");
    private static final Map<String, String> ROLES = Map.of("admin", "admin,guest", "guest", "guest");
    private String name;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setRoleClassNames(String names) {
    }

    public Subject login(HttpPrincipal principal) throws LoginException {
        if (!AUTH.containsKey(principal.getUsername()) || !AUTH.get(principal.getUsername()).equals(principal.getPassword())) {
            return null;
        }
        Subject subject = new Subject();
        subject.getPrincipals().addAll(Arrays.stream(ROLES.get(principal.getUsername()).split(",")).map(TestRolePrincipal::new).collect(Collectors.toSet()));
        return subject;
    }

    public void logout(Subject subject) throws LoginException {
    }

    public String getUserRoles(Subject subject) {
        return subject.getPrincipals().stream().map(Principal::getName).collect(Collectors.joining(","));
    }
}

