/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.http.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.proxy.HttpProxyHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.camel.component.netty.ClientInitializerFactory;
import org.apache.camel.component.netty.NettyProducer;
import org.apache.camel.component.netty.http.HttpClientInitializerFactory;
import org.apache.camel.component.netty.http.NettyHttpProducer;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public class ProxyCapableClientInitializerFactory
extends HttpClientInitializerFactory {
    public ProxyCapableClientInitializerFactory() {
    }

    public ProxyCapableClientInitializerFactory(NettyHttpProducer producer) {
        super(producer);
    }

    protected void initChannel(Channel channel) throws Exception {
        Config config = ConfigProvider.getConfig();
        String proxyHost = (String)config.getValue("tiny.proxy.host", String.class);
        Integer proxyPort = (Integer)config.getValue("tiny.proxy.port", Integer.class);
        InetSocketAddress proxyServerAddress = new InetSocketAddress(proxyHost, (int)proxyPort);
        HttpProxyHandler httpProxyHandler = new HttpProxyHandler((SocketAddress)proxyServerAddress, "admin", "adm1n");
        httpProxyHandler.setConnectTimeoutMillis(5000L);
        super.initChannel(channel);
        channel.pipeline().addFirst(new ChannelHandler[]{httpProxyHandler});
    }

    public ClientInitializerFactory createPipelineFactory(NettyProducer producer) {
        return new ProxyCapableClientInitializerFactory((NettyHttpProducer)producer);
    }
}

