/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.http.netty;

import io.netty.handler.codec.http.FullHttpRequest;
import io.quarkus.runtime.annotations.RegisterForReflection;
import jakarta.inject.Named;
import java.nio.charset.Charset;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.netty.http.JAASSecurityAuthenticator;
import org.apache.camel.component.netty.http.NettyHttpComponent;
import org.apache.camel.component.netty.http.NettyHttpConfiguration;
import org.apache.camel.component.netty.http.NettyHttpMessage;
import org.apache.camel.component.netty.http.NettyHttpSecurityConfiguration;
import org.apache.camel.component.netty.http.SecurityAuthenticator;
import org.apache.camel.component.netty.http.SecurityConstraint;
import org.apache.camel.component.netty.http.SecurityConstraintMapping;
import org.apache.camel.model.rest.RestBindingMode;
import org.apache.camel.quarkus.component.http.netty.auth.TestAuthenticator;
import org.apache.camel.quarkus.component.http.netty.pojo.UserPojo;
import org.eclipse.microprofile.config.ConfigProvider;

@RegisterForReflection(targets={IllegalStateException.class}, serialization=true)
public class NettyHttpRoutes
extends RouteBuilder {
    @Named(value="jaasConfig")
    NettyHttpSecurityConfiguration jaasConfig() {
        NettyHttpSecurityConfiguration config = new NettyHttpSecurityConfiguration();
        config.setRealm("Quarkus");
        JAASSecurityAuthenticator jaas = new JAASSecurityAuthenticator();
        jaas.setName("Quarkus");
        config.setSecurityAuthenticator((SecurityAuthenticator)jaas);
        return config;
    }

    @Named(value="securityConfig")
    NettyHttpSecurityConfiguration securityConfiguration() {
        NettyHttpSecurityConfiguration config = new NettyHttpSecurityConfiguration();
        config.setRealm("Quarkus");
        config.setSecurityAuthenticator((SecurityAuthenticator)new TestAuthenticator());
        return config;
    }

    @Named(value="acladmin")
    NettyHttpSecurityConfiguration aclAdmin() {
        NettyHttpSecurityConfiguration config = this.securityConfiguration();
        SecurityConstraintMapping securityConstraintMapping = new SecurityConstraintMapping();
        securityConstraintMapping.addInclusion("/*", "admin");
        config.setSecurityConstraint((SecurityConstraint)securityConstraintMapping);
        return config;
    }

    @Named(value="aclguest")
    NettyHttpSecurityConfiguration aclGuest() {
        NettyHttpSecurityConfiguration config = this.securityConfiguration();
        SecurityConstraintMapping securityConstraintMapping = new SecurityConstraintMapping();
        securityConstraintMapping.addInclusion("/*", "admin,guest");
        config.setSecurityConstraint((SecurityConstraint)securityConstraintMapping);
        return config;
    }

    @Named(value="aclpublic")
    NettyHttpSecurityConfiguration aclPublic() {
        NettyHttpSecurityConfiguration config = this.securityConfiguration();
        SecurityConstraintMapping securityConstraintMapping = new SecurityConstraintMapping();
        securityConstraintMapping.addExclusion("/*");
        config.setSecurityConstraint((SecurityConstraint)securityConstraintMapping);
        return config;
    }

    @Named(value="aclwildcard")
    NettyHttpSecurityConfiguration aclWildcard() {
        NettyHttpSecurityConfiguration config = this.securityConfiguration();
        SecurityConstraintMapping securityConstraintMapping = new SecurityConstraintMapping();
        securityConstraintMapping.addInclusion("/*", "*");
        config.setSecurityConstraint((SecurityConstraint)securityConstraintMapping);
        return config;
    }

    @Named(value="netty-http")
    NettyHttpComponent component() {
        NettyHttpComponent component = new NettyHttpComponent();
        NettyHttpConfiguration config = new NettyHttpConfiguration();
        config.setReuseChannel(true);
        component.setConfiguration(config);
        return component;
    }

    public void configure() throws Exception {
        this.from("direct:netty-http-https").to("netty-http:https://localhost:{{quarkus.http.test-ssl-port}}/service/common/https?ssl=true&sslContextParameters=#sslContextParameters");
        this.from("netty-http:http://0.0.0.0:{{camel.netty-http.test-port}}/test/server/hello").transform().constant((Object)"Netty Hello World");
        this.from("netty-http:http://0.0.0.0:{{camel.netty-http.test-port}}/test/server/serialized/exception?transferException=true").throwException((Exception)new IllegalStateException("Forced exception"));
        this.from("netty-http:http://0.0.0.0:{{camel.netty-http.compression-test-port}}/compressed?compression=true").transform().constant((Object)"Netty Hello World Compressed");
        this.restConfiguration().component("netty-http").host("localhost").port(((Integer)ConfigProvider.getConfig().getValue("camel.netty-http.restPort", Integer.class)).intValue());
        this.from("netty-http:http://localhost:{{camel.netty-http.port}}/request").process(ex -> {
            FullHttpRequest req = ((NettyHttpMessage)ex.getIn(NettyHttpMessage.class)).getHttpRequest();
            ex.getIn().setBody((Object)String.join((CharSequence)",", req.method().name(), req.content().toString(Charset.defaultCharset()), StreamSupport.stream(req.headers().spliterator(), false).map(h -> (String)h.getKey() + ":" + (String)h.getValue()).collect(Collectors.joining(","))));
        });
        this.from("netty-http:http://localhost:{{camel.netty-http.port}}/response").transform().simple("Received message ${body}");
        this.from("netty-http:http://localhost:{{camel.netty-http.port}}/auth?securityConfiguration=#securityConfig").log("success");
        this.from("netty-http:http://localhost:{{camel.netty-http.port}}/jaas?securityConfiguration=#jaasConfig").log("success");
        this.from("netty-http:http://localhost:{{camel.netty-http.port}}/acls/admin?securityConfiguration=#acladmin").log("success");
        this.from("netty-http:http://localhost:{{camel.netty-http.port}}/acls/guest?securityConfiguration=#aclguest").log("success");
        this.from("netty-http:http://localhost:{{camel.netty-http.port}}/acls/wildcard?securityConfiguration=#aclwildcard").log("success");
        this.from("netty-http:http://localhost:{{camel.netty-http.port}}/acls/public?securityConfiguration=#aclpublic").log("success");
        this.from("netty-http:http://localhost:{{camel.netty-http.port}}/wildcard?matchOnUriPrefix=true").setBody().constant((Object)"wildcard matched");
        this.from("netty-http:proxy://localhost:{{camel.netty-http.proxyPort}}?reuseChannel=false").toD("netty-http:http://${headers.CamelHttpHost}:${headers.CamelHttpPort}/${headers.CamelHttpPath}");
        this.from("netty-http:http://localhost:{{camel.netty-http.port}}/proxy").setBody().constant((Object)"proxy");
        this.rest("/rest").get("/").to("direct:printMethod").post("/").to("direct:printMethod").put("/").to("direct:printMethod").post("/json").bindingMode(RestBindingMode.json).consumes("application/json").type(UserPojo.class).to("direct:printBody").post("/xml").bindingMode(RestBindingMode.xml).consumes("application/xml").type(UserPojo.class).to("direct:printBody");
        this.from("direct:printMethod").setBody().header("CamelHttpMethod");
        this.from("direct:printBody").process(e -> {
            e.getIn().setHeader("Content-Type", (Object)"text/plain");
            e.getIn().setBody((Object)((UserPojo)e.getIn().getBody(UserPojo.class)).toString());
        });
    }
}

