/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.http.netty;

import io.netty.handler.codec.http.FullHttpResponse;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.camel.Exchange;
import org.apache.camel.component.netty.http.NettyHttpMessage;
import org.apache.camel.quarkus.component.http.common.AbstractHttpResource;
import org.apache.camel.util.IOHelper;

@Path(value="/test/client/netty-http")
@ApplicationScoped
public class NettyHttpResource
extends AbstractHttpResource {
    @Override
    @Path(value="/get")
    @GET
    @Produces(value={"text/plain"})
    public String httpGet(@QueryParam(value="test-port") int port) {
        return (String)this.producerTemplate.toF("netty-http:http://localhost:%d/service/common/get?bridgeEndpoint=true", new Object[]{port}).withHeader("CamelHttpMethod", (Object)"GET").request(String.class);
    }

    @Override
    @Path(value="/post")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String httpPost(@QueryParam(value="test-port") int port, String message) {
        return (String)this.producerTemplate.toF("netty-http:http://localhost:%d/service/common/toUpper?bridgeEndpoint=true", new Object[]{port}).withBody((Object)message).withHeader("Content-Type", (Object)"text/plain").withHeader("CamelHttpMethod", (Object)"POST").request(String.class);
    }

    @Override
    @Path(value="/auth/basic")
    @GET
    @Produces(value={"text/plain"})
    public Response basicAuth(@QueryParam(value="test-port") int port, @QueryParam(value="username") String username, @QueryParam(value="password") String password) {
        String credentials = username + ":" + password;
        String encoded = Base64.getEncoder().encodeToString(credentials.getBytes(StandardCharsets.UTF_8));
        Exchange result = this.producerTemplate.withHeader("CamelHttpQuery", (Object)"component=netty-http").withHeader("Authorization", (Object)("Basic " + encoded)).toF("netty-http:http://localhost:%d/test/client/netty-http/auth/basic/secured?throwExceptionOnFailure=false", new Object[]{port}).send();
        Integer status = (Integer)result.getMessage().getHeader("CamelHttpResponseCode", Integer.class);
        String body = (String)result.getMessage().getBody(String.class);
        return Response.status((int)status).entity((Object)body).build();
    }

    @Override
    @Path(value="/proxy")
    @GET
    @Produces(value={"application/xml"})
    public String httpProxy() {
        String url = String.format("https://repo.maven.apache.org/maven2/org/apache/camel/quarkus/camel-quarkus-%s/maven-metadata.xml", "netty-http");
        return (String)this.producerTemplate.withHeader("CamelHttpQuery", (Object)"component=netty-http").toF("netty-http:%s?clientInitializerFactory=#proxyCapableClientInitializerFactory", new Object[]{url}).request(String.class);
    }

    @Path(value="/compression")
    @GET
    @Produces(value={"text/plain"})
    public String compression(@QueryParam(value="test-port") int port) throws IOException {
        byte[] compressed = (byte[])this.producerTemplate.toF("netty-http:http://localhost:%d/compressed", new Object[]{port}).withHeader("Accept-Encoding", (Object)"gzip, deflate").request(byte[].class);
        try (GZIPInputStream inputStream = new GZIPInputStream(new ByteArrayInputStream(compressed));){
            String string = IOHelper.loadText((InputStream)inputStream).trim();
            return string;
        }
    }

    @Path(value="/serialized/exception")
    @GET
    @Produces(value={"text/plain"})
    public String nettyHttpSerializedException(@QueryParam(value="test-port") int port) {
        Exchange exchange = this.producerTemplate.toF("netty-http:http://localhost:%d/test/server/serialized/exception?transferException=true", new Object[]{port}).withHeader("CamelHttpMethod", (Object)"GET").send();
        return exchange.getException().getClass().getName();
    }

    @GET
    @Path(value="/getRequest/{method}/{hName}/{hValue}/{body}")
    public String getRequest(@PathParam(value="method") String method, @PathParam(value="hName") String headerName, @PathParam(value="hValue") String headerValue, @PathParam(value="body") String body, @QueryParam(value="test-port") int port) {
        return (String)this.producerTemplate.toF("netty-http:http://localhost:%d/request", new Object[]{port}).withHeaders(Map.of("CamelHttpMethod", method, headerName, headerValue)).withBody((Object)body).request(String.class);
    }

    @GET
    @Path(value="/getResponse/{message}")
    public String getResponse(@PathParam(value="message") String message, @QueryParam(value="test-port") int port) {
        Exchange exchange = this.producerTemplate.toF("netty-http:http://localhost:%d/response", new Object[]{port}).withBody((Object)message).send();
        FullHttpResponse response = ((NettyHttpMessage)exchange.getIn().getBody(NettyHttpMessage.class)).getHttpResponse();
        String received = (String)exchange.getIn().getBody(String.class);
        return received + ": " + response.status().reasonPhrase() + " " + response.status().code();
    }

    @GET
    @Path(value="/wildcard/{path}")
    public String wildcard(@PathParam(value="path") String path, @QueryParam(value="test-port") int port) {
        return (String)this.producerTemplate.toF("netty-http:http://localhost:%d/%s", new Object[]{port, path}).withHeader("CamelHttpMethod", (Object)"GET").request(String.class);
    }

    @GET
    @Path(value="/consumer-proxy")
    public String proxy(@QueryParam(value="test-port") int port, @QueryParam(value="proxy-port") int proxyPort) {
        Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress("localhost", proxyPort));
        String url = "http://localhost:" + port + "/proxy";
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection(proxy);
            return new String(connection.getInputStream().readAllBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @GET
    @Path(value="/auth/{path}/{user}/{password}")
    public Response auth(@QueryParam(value="test-port") int port, @PathParam(value="path") String path, @PathParam(value="user") String user, @PathParam(value="password") String password) {
        Exchange exchange = this.producerTemplate.toF("netty-http:http://localhost:%d/%s", new Object[]{port, path}).withHeaders(this.getAuthHeaders(user, password)).send();
        return Response.status((int)((Integer)exchange.getIn().getHeader("CamelHttpResponseCode", Integer.class))).build();
    }

    @GET
    @Path(value="/rest/{method}")
    public String rest(@QueryParam(value="rest-port") int port, @PathParam(value="method") String method) {
        return (String)this.producerTemplate.toF("netty-http:http://localhost:%d/rest", new Object[]{port}).withHeader("CamelHttpMethod", (Object)method).request(String.class);
    }

    @GET
    @Path(value="/rest/pojo/{type}")
    public String restPojo(@QueryParam(value="rest-port") int port, @PathParam(value="type") String type) {
        String contentType;
        String body;
        if ("json".equals(type)) {
            body = "{\"firstName\":\"John\", \"lastName\":\"Doe\"}";
            contentType = "application/json";
        } else {
            body = "<user firstName=\"John\" lastName=\"Doe\"/>";
            contentType = "text/xml";
        }
        return (String)this.producerTemplate.toF("netty-http:http://localhost:%d/rest/%s", new Object[]{port, type}).withBody((Object)body).withHeaders(Map.of("CamelHttpMethod", "POST", "Content-Type", contentType)).request(String.class);
    }

    @GET
    @Path(value="/jaas/{user}/{password}")
    public Response auth(@QueryParam(value="test-port") int port, @PathParam(value="user") String user, @PathParam(value="password") String password) {
        Exchange exchange = this.producerTemplate.toF("netty-http:http://localhost:%d/jaas", new Object[]{port}).withHeaders(this.getAuthHeaders(user, password)).send();
        return Response.status((int)((Integer)exchange.getIn().getHeader("CamelHttpResponseCode", Integer.class))).build();
    }

    private Map<String, Object> getAuthHeaders(String user, String password) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("CamelHttpMethod", "GET");
        if (!"null".equals(user)) {
            headers.put("Authorization", "Basic " + Base64.getEncoder().encodeToString((user + ":" + password).getBytes()));
        }
        return headers;
    }
}

